/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.api;

import filenet.vw.api.IVWtoXML;
import filenet.vw.api.VWApplicationSpaceDefinition;
import filenet.vw.api.VWAttributeInfo;
import filenet.vw.api.VWDBExecuteConnection;
import filenet.vw.api.VWException;
import filenet.vw.api.VWExposedFieldDefinition;
import filenet.vw.api.VWFieldType;
import filenet.vw.api.VWGuid;
import filenet.vw.api.VWIndexDefinition;
import filenet.vw.api.VWLogDefinition;
import filenet.vw.api.VWModeType;
import filenet.vw.api.VWOperationDefinition;
import filenet.vw.api.VWParameterDefinition;
import filenet.vw.api.VWQueueDefinition;
import filenet.vw.api.VWResolver;
import filenet.vw.api.VWRoleDefinition;
import filenet.vw.api.VWRosterDefinition;
import filenet.vw.api.VWSession;
import filenet.vw.api.VWStepProcessorInfoDefinition;
import filenet.vw.api.VWSystemAdministration;
import filenet.vw.api.VWSystemConfiguration;
import filenet.vw.api.VWTableDefinition;
import filenet.vw.api.VWUserInfo;
import filenet.vw.api.VWWorkBasketColumnDefinition;
import filenet.vw.api.VWWorkBasketDefinition;
import filenet.vw.api.VWWorkBasketFilterDefinition;
import filenet.vw.api.VWXMLErrorHandler;
import filenet.vw.api.VWXMLHandler;
import filenet.vw.api.VWXMLUtil;
import filenet.vw.api.VWXML_CUR_parser;
import filenet.vw.base.VWAuthItem;
import filenet.vw.base.VWCapsuleAES;
import filenet.vw.base.VWLocale;
import filenet.vw.base.VWString;
import filenet.vw.base.VWUDDIRegistryList;
import filenet.vw.base.VWWSRRRegistryList;
import filenet.vw.base.XMLHelper;
import filenet.vw.base.logging.Logger;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.juddi.datatype.business.BusinessEntity;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class VWXMLConfiguration {
    private static final int MASK_GROUP_1_OPTIONS = 15;
    private static final int MASK_GROUP_2_OPTIONS = 240;
    public static final int IMPORT_REPLACE = 1;
    public static final int IMPORT_MERGE = 2;
    public static final int IMPORT_EXCLUDE_USERINFO = 16;
    private static String apiVersion;
    private static Logger logger;
    private static VWString vstrImportOverwrite;
    private static VWString vstrImportMerge;
    public static final String ATTRINFO_CONFIG_ALLOW_USER_ENTER_WSDL = "F_AllowUserEnterWSDL";

    public static String _get_FILE_DATE() {
        return "$Date: 2010-07-22 23:34:08 GMT $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author: Darik Siegfried;5D6048897;dsiegfried@us.ibm.com (dsiegfried) $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision: /main/PUI_451_Int/PUI_460_Int/17 $";
    }

    public static void exportConfiguration(IVWtoXML[] apiObjects, StringBuffer buffer) throws VWException {
        try {
            buffer.append(VWXMLConfiguration.makeXMLBlock(apiObjects));
        }
        catch (Exception ex1) {
            VWException vwex = new VWException("vw.api.VWXMLConfigurationXMLWriteToFileError", " Exception writing XML to file, {0}.", ex1.getMessage());
            vwex.setCause(ex1);
            throw vwex;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void exportConfigurationToFile(IVWtoXML[] apiObjects, String outputFile) throws VWException {
        if (outputFile == null) throw new VWException("vw.api.VWXMLConfigurationNullConfig", "Configuration output file name is null or empty.");
        if (outputFile.length() < 1) {
            throw new VWException("vw.api.VWXMLConfigurationNullConfig", "Configuration output file name is null or empty.");
        }
        FileOutputStream ostream = null;
        try {
            try {
                ostream = new FileOutputStream(outputFile);
                String buffer = VWXMLConfiguration.makeXMLBlock(apiObjects);
                try {
                    OutputStreamWriter out = new OutputStreamWriter((OutputStream)ostream, "UTF8");
                    out.write(buffer);
                    ((Writer)out).flush();
                    ((Writer)out).close();
                }
                catch (Exception ex2) {
                    VWException vwex = new VWException("vw.api.VWXMLConfigurationXMLWriteError", " Exception writing XML, {0}.", ex2.getMessage());
                    vwex.setCause(ex2);
                    throw vwex;
                }
                Object var7_9 = null;
                if (ostream == null) return;
            }
            catch (Exception ex1) {
                VWException vwex = new VWException("vw.api.VWXMLConfigurationXMLWriteToFileError", " Exception writing XML to file, {0}.", ex1.getMessage());
                vwex.setCause(ex1);
                throw vwex;
            }
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            if (ostream == null) throw throwable;
            try {
                ((OutputStream)ostream).close();
                throw throwable;
            }
            catch (Exception ex3) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception ex3) {}
        ((OutputStream)ostream).close();
        return;
    }

    protected static void importConfiguration(VWSession session, Document doc, int option, StringBuffer progressLog) throws Exception {
        NodeList sysConfigList;
        NodeList userInfoList;
        NodeList sysAdminList;
        Element configEle = doc.getDocumentElement();
        if (!VWXMLConfiguration.validateConfigurationXML(doc, configEle)) {
            throw new VWException("vw.api.VWXMLConfigurationInvalidXMLDocument", "Invalid configuration XML document");
        }
        apiVersion = configEle.getAttribute("ApiVersion");
        if (apiVersion == null || apiVersion.length() <= 0) {
            throw new VWException("vw.api.VWXMLConfigurationInvalidXMLDocument", "Invalid configuration XML document");
        }
        if (logger.isFinest()) {
            logger.finest("importConfiguration enter-- version=" + apiVersion);
        }
        if ((sysAdminList = configEle.getElementsByTagName("SystemAdministration")) != null && sysAdminList.getLength() > 0) {
            if (sysAdminList.getLength() > 1) {
                throw new VWException("vw.api.VWXMLConfigurationMultipleSysAdmin", "Multiple system administrations detected in XML document");
            }
            VWSystemAdministration sysAdmin = session.fetchSystemAdministration();
            VWXMLConfiguration.importSystemAdministration(session, sysAdmin, sysAdminList, option, progressLog);
        }
        if ((option & 0x10) == 0 && (userInfoList = configEle.getElementsByTagName("ArrayOfUserInfo")) != null && userInfoList.getLength() > 0) {
            VWString progLogMsg = new VWString("vw.api.VWXMLConfiguration.importConfigurationUserInfo", "Import user information\n");
            progressLog.append(progLogMsg.toString());
            VWSystemAdministration sysAdmin = session.fetchSystemAdministration();
            for (int i = 0; i < userInfoList.getLength(); ++i) {
                VWUserInfo[] userInfoRecords = VWXMLConfiguration.parseXMLUserInfoRecords(userInfoList.item(i), sysAdmin, option, progressLog);
                if (userInfoRecords == null) continue;
                for (int ii = 0; ii < userInfoRecords.length; ++ii) {
                    userInfoRecords[ii].save();
                }
            }
            progLogMsg = new VWString("vw.api.VWXMLConfiguration.importConfigurationUserInfoEnd", "Import user information succeeded\n\n");
            progressLog.append(progLogMsg.toString());
        }
        if ((sysConfigList = configEle.getElementsByTagName("SystemConfiguration")) != null && sysConfigList.getLength() > 0) {
            if (sysAdminList.getLength() > 1) {
                throw new VWException("vw.api.VWXMLConfigurationMultipleSysConfig", "Multiple system configurations detected in XML document");
            }
            VWSystemConfiguration sysConfig = session.fetchSystemConfiguration();
            VWXMLConfiguration.importSystemConfiguration(sysConfig, sysConfigList, session, option, progressLog);
            String[] errors = sysConfig.commit();
            if (errors != null) {
                StringBuffer error_str = new StringBuffer();
                for (int i = 0; i < errors.length; ++i) {
                    error_str.append(errors[i] + "\n");
                }
                throw new VWException("vw.api.VWXMLConfigurationImportCommitError", "Errors occurred during commit:\n {0}", error_str.toString());
            }
        } else {
            NodeList otherNodes = configEle.getChildNodes();
            if (otherNodes != null && otherNodes.getLength() > 0) {
                VWSystemConfiguration sysConfig = session.fetchSystemConfiguration();
                VWXMLConfiguration.importConfigurationChildElements(otherNodes, sysConfig, session, option, progressLog);
                String[] errors = sysConfig.commit();
                if (errors != null) {
                    StringBuffer error_str = new StringBuffer();
                    for (int i = 0; i < errors.length; ++i) {
                        error_str.append(errors[i] + "\n");
                    }
                    throw new VWException("vw.api.VWXMLConfigurationImportCommitError2", "Errors occurred during commit:\n {0}", error_str.toString());
                }
            }
        }
        if (logger.isFinest()) {
            logger.finest("importConfiguration --");
        }
    }

    public static String importConfiguration(VWSession session, String config, int option) throws VWException {
        VWString progLogMsg;
        if (session == null) {
            throw new VWException("vw.api.VWXMLConfigurationNullSession", "The VWSession is null.");
        }
        if (config == null || config.length() < 1) {
            throw new VWException("vw.api.VWXMLConfigurationNullConfig", "Configuration input is null or empty.");
        }
        if (!VWXMLConfiguration.checkOption(option)) {
            throw new VWException("vw.api.VWXMLConfigurationInvalidOptoin", "Invalid import option. Must specify IMPORT_MERGE or IMPORT_REPLACE combined with other options");
        }
        StringBuffer progressLog = new StringBuffer();
        try {
            if (logger.isFinest()) {
                logger.finest("importConfigurationFromString enter-- option=" + option);
            }
            progLogMsg = new VWString("vw.api.VWXMLConfiguration.importConfigurationFromString", "Import option: {1}\n\n");
            progressLog.append(progLogMsg.toString(option == 1 ? vstrImportOverwrite : vstrImportMerge));
            InputSource inSrc = new InputSource(new StringReader(config));
            Document doc = XMLHelper.parseDocumentViaDOM(inSrc, new VWResolver(), new VWXMLErrorHandler(), false);
            VWXMLConfiguration.importConfiguration(session, doc, option, progressLog);
        }
        catch (Exception ex) {
            VWException vwex = new VWException("vw.api.VWXMLConfigurationImportError", " Exception during configuration import, {0}.", ex.getMessage());
            vwex.setCause(ex);
            throw vwex;
        }
        progLogMsg = new VWString("vw.api.VWXMLConfiguration.importConfigurationFromStringEnd", "\nImport configuration succeeded\n\n");
        progressLog.append(progLogMsg.toString());
        if (logger.isFinest()) {
            logger.finest("importConfigurationFromString -- ");
        }
        return progressLog.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String importConfigurationFromFile(VWSession session, String inputFile, int option) throws VWException {
        VWString progLogMsg;
        StringBuffer progressLog;
        block11: {
            if (session == null) {
                throw new VWException("vw.api.VWXMLConfigurationNullSession", "The VWSession is null.");
            }
            if (inputFile == null) throw new VWException("vw.api.VWXMLConfigurationNullConfig", "Configuration input is null or empty.");
            if (inputFile.length() < 1) {
                throw new VWException("vw.api.VWXMLConfigurationNullConfig", "Configuration input is null or empty.");
            }
            if (!VWXMLConfiguration.checkOption(option)) {
                throw new VWException("vw.api.VWXMLConfigurationInvalidOptoin", "Invalid import option.");
            }
            progressLog = new StringBuffer();
            FileInputStream in = null;
            try {
                try {
                    if (logger.isFinest()) {
                        logger.finest("importConfigurationFromFile enter--, file= " + inputFile + " option=" + option);
                    }
                    progLogMsg = new VWString("vw.api.VWXMLConfiguration.importConfigurationFromFile", "Import configuration from file \"{0}\"\nImport option: {1}\n\n");
                    progressLog.append(progLogMsg.toString(inputFile, option == 1 ? vstrImportOverwrite : vstrImportMerge));
                    in = new FileInputStream(inputFile);
                    InputSource inSrc = new InputSource(in);
                    Document doc = XMLHelper.parseDocumentViaDOM(inSrc, new VWResolver(), new VWXMLErrorHandler(), false);
                    VWXMLConfiguration.importConfiguration(session, doc, option, progressLog);
                }
                catch (Exception ex) {
                    VWException vwex = new VWException("vw.api.VWXMLConfigurationImportFromFileError", " Exception during import from file, {0}.", ex.getMessage());
                    vwex.setCause(ex);
                    throw vwex;
                }
                Object var9_10 = null;
                if (in == null) break block11;
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                if (in == null) throw throwable;
                try {
                    in.close();
                    throw throwable;
                }
                catch (Exception ignore) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (Exception ignore) {}
            in.close();
        }
        progLogMsg = new VWString("vw.api.VWXMLConfiguration.importConfigurationFromFileEnd", "\nImport configuration from file \"{0}\" succeeded\n\n");
        progressLog.append(progLogMsg.toString(inputFile));
        if (!logger.isFinest()) return progressLog.toString();
        logger.finest("importConfigurationFromFile -- ");
        return progressLog.toString();
    }

    public static String makeXMLBlock(IVWtoXML[] apiObjects) throws VWException {
        if (apiObjects != null && apiObjects.length > 0) {
            StringBuffer tmpSBuf = new StringBuffer();
            tmpSBuf.append("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n");
            tmpSBuf.append("<eProcessConfiguration");
            tmpSBuf.append(" xmlns=\"http://filenet.com/vw/api/configuration/1.0\"\n");
            tmpSBuf.append("ApiVersion=\"4.0\">\n");
            if (apiObjects != null) {
                int i;
                boolean bContainsUserInfo = false;
                for (i = 0; i < apiObjects.length; ++i) {
                    if (apiObjects[i] == null) continue;
                    if (apiObjects[i] instanceof VWSystemConfiguration || apiObjects[i] instanceof VWSystemAdministration || apiObjects[i] instanceof VWLogDefinition || apiObjects[i] instanceof VWQueueDefinition || apiObjects[i] instanceof VWRosterDefinition || apiObjects[i] instanceof VWApplicationSpaceDefinition || apiObjects[i] instanceof VWStepProcessorInfoDefinition) {
                        apiObjects[i].toXML(tmpSBuf);
                        continue;
                    }
                    if (!(apiObjects[i] instanceof VWUserInfo)) continue;
                    bContainsUserInfo = true;
                }
                if (bContainsUserInfo) {
                    tmpSBuf.append("<ArrayOfUserInfo>\n");
                    for (i = 0; i < apiObjects.length; ++i) {
                        if (!(apiObjects[i] instanceof VWUserInfo)) continue;
                        ((VWUserInfo)apiObjects[i]).toXML(tmpSBuf, "\t");
                    }
                    tmpSBuf.append("</ArrayOfUserInfo>\n");
                }
            }
            tmpSBuf.append("</eProcessConfiguration>\n");
            return tmpSBuf.toString();
        }
        throw new VWException("vw.api.VWXMLConfigurationInvalidObject", "An invalid object was passed in to export.");
    }

    protected static void hashtableToXML(Hashtable theTable, int keyType, StringBuffer theBuffer, String elementName, String baseIndent) throws VWException {
        if (theBuffer == null) {
            throw new VWException("vw.api.VWAttributeInfoNullBuffer", "buffer parameter cannot be null.");
        }
        if (theTable == null || theTable.size() == 0) {
            return;
        }
        if (baseIndent == null) {
            baseIndent = "";
        }
        String INDENT_0 = baseIndent;
        String INDENT_1 = INDENT_0 + "\t";
        String INDENT_2 = INDENT_1 + "\t";
        Enumeration theKeys = theTable.keys();
        while (theKeys.hasMoreElements()) {
            Object nextKey = theKeys.nextElement();
            Object nextValue = theTable.get(nextKey);
            theBuffer.append(INDENT_0 + "<" + elementName + "\n");
            boolean bIsArray = nextValue.getClass().isArray();
            String sType = Integer.toString(VWFieldType.getVWFieldType(nextValue));
            theBuffer.append(INDENT_1 + "Name" + "=\"" + VWXMLHandler.toXMLString(nextKey.toString()) + "\"\n");
            theBuffer.append(INDENT_1 + "KeyType" + "=\"" + Integer.toString(keyType) + "\"\n");
            theBuffer.append(INDENT_1 + "Type" + "=\"" + VWXMLHandler.toXMLString(sType) + "\"\n");
            theBuffer.append(INDENT_1 + "IsArray" + "=\"" + VWXMLHandler.booleanToString(bIsArray) + "\">\n");
            if (!bIsArray) {
                if (nextValue instanceof Date) {
                    theBuffer.append(INDENT_2 + "<" + "Value" + ">" + VWXMLHandler.toXMLString(VWXMLUtil.convertDateToUTCString((Date)nextValue)) + "</" + "Value" + ">\n");
                } else {
                    theBuffer.append(INDENT_2 + "<" + "Value" + ">" + VWXMLHandler.toXMLString(nextValue.toString()) + "</" + "Value" + ">\n");
                }
            } else {
                int arrayCount = ((Object[])nextValue).length;
                for (int i = 0; i < arrayCount; ++i) {
                    if (((Object[])nextValue)[i] instanceof Date) {
                        theBuffer.append(INDENT_2 + "<" + "Value" + ">" + VWXMLHandler.toXMLString(VWXMLUtil.convertDateToUTCString((Date)((Object[])nextValue)[i])) + "</" + "Value" + ">\n");
                        continue;
                    }
                    theBuffer.append(INDENT_2 + "<" + "Value" + ">" + VWXMLHandler.toXMLString(((Object[])nextValue)[i].toString()) + "</" + "Value" + ">\n");
                }
            }
            theBuffer.append(INDENT_0 + "</" + elementName + ">\n");
        }
    }

    protected static void decryptDbExecutePWD(VWDBExecuteConnection aDbExe) throws Exception {
        VWCapsuleAES aes = new VWCapsuleAES();
        VWAuthItem authItem = aes.decrypt(aDbExe.getPWD());
        aDbExe.setPWD(authItem == null ? null : authItem.getPassword());
    }

    protected static void importSystemAdministration(VWSession session, VWSystemAdministration sysAdmin, NodeList sysAdminList, int option, StringBuffer progressLog) throws Exception {
        NodeList childNodes;
        String str3;
        if (sysAdminList.getLength() == 0) {
            return;
        }
        if (sysAdmin == null) {
            throw new VWException("vw.api.VWXMLConfigurationSysAdminNull", "The SystemAdministration object is null.");
        }
        if (logger.isFinest()) {
            logger.finest("importSystemAdministration enter-- ");
        }
        VWString progLogMsg = new VWString("vw.api.VWXMLConfiguration.importSystemAdministration", "Import system administration\n");
        progressLog.append(progLogMsg.toString());
        Element SystemAdminEle = (Element)sysAdminList.item(0);
        if ((option & 0xF) == 1) {
            String str2;
            String str1 = SystemAdminEle.getAttribute("SessionTimeOut");
            if (str1 != null && str1.length() > 0) {
                int sessionTimeOut = Integer.parseInt(str1);
                sysAdmin.setSessionTimeOut(sessionTimeOut);
            }
            if ((str2 = SystemAdminEle.getAttribute("StatisticsConsolidationInterval")) != null && str2.length() > 0) {
                int theInterval = Integer.parseInt(str2);
                sysAdmin.setStatisticsConsolidationInterval(theInterval);
            }
        }
        if ((str3 = SystemAdminEle.getAttribute("SystemWideFlags")) != null && str3.length() > 0) {
            int resultFlags;
            int theSourceFlags = Integer.parseInt(str3);
            if ((option & 0xF) == 2) {
                int targetFlags = sysAdmin.getSystemWideFlags();
                resultFlags = VWXMLConfiguration.mergeSystemWideFlags(theSourceFlags, targetFlags);
            } else {
                resultFlags = theSourceFlags;
            }
            sysAdmin.setSystemFlags(resultFlags);
        }
        if ((childNodes = SystemAdminEle.getChildNodes()) == null || childNodes.getLength() <= 0) {
            return;
        }
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node aNode = childNodes.item(i);
            String nodeName = aNode.getNodeName();
            if (nodeName.equals("ModelAttributes")) {
                Hashtable attributes = VWXMLConfiguration.parseXMLModelAttributes(aNode, apiVersion);
                if ((option & 0xF) == 2) {
                    VWAttributeInfo theAttributeInfo = VWXMLConfiguration.mergeAttributes(session, sysAdmin.getAttributeInfo(), attributes);
                    sysAdmin.setAttributeInfo(theAttributeInfo);
                    continue;
                }
                sysAdmin.setAttributes(attributes);
                continue;
            }
            if (!nodeName.equals("ArrayOfDBExecuteConnection")) continue;
            VWDBExecuteConnection[] dbExecuteList = VWXMLConfiguration.parseXMLDBExecuteConnectionArray(aNode);
            for (int ix = 0; ix < dbExecuteList.length; ++ix) {
                String dbExecuteName = dbExecuteList[ix].getName();
                VWDBExecuteConnection aDBExe = sysAdmin.getDBExecutionConnection(dbExecuteName);
                if (aDBExe == null) {
                    aDBExe = sysAdmin.createDBExecutionConnection(dbExecuteName);
                    aDBExe.copy(dbExecuteList[ix]);
                    VWXMLConfiguration.decryptDbExecutePWD(aDBExe);
                    aDBExe.setHasChanged(true);
                    continue;
                }
                if ((option & 0xF) != 1) continue;
                aDBExe.copy(dbExecuteList[ix]);
                VWXMLConfiguration.decryptDbExecutePWD(aDBExe);
                aDBExe.setHasChanged(true);
            }
        }
        sysAdmin.commit();
        progLogMsg = new VWString("vw.api.VWXMLConfiguration.importSystemAdministrationEnd", "Import system administration succeeded\n\n");
        progressLog.append(progLogMsg.toString());
        if (logger.isFinest()) {
            logger.finest("importSystemAdministration -- ");
        }
    }

    protected static StringBuffer parseConfigurationXML(VWSystemConfiguration sysConfig, VWSession session, BufferedReader inputXML) throws IOException, SAXException, VWException, NumberFormatException {
        VWString progLogMsg;
        if (inputXML == null) {
            throw new VWException("vw.api.VWXMLConfigurationNullConfig", "Configuration input is null or empty.");
        }
        StringBuffer progressLog = new StringBuffer();
        try {
            if (logger.isFinest()) {
                logger.finest("*** Entering parseConfigurationXML *** version = " + apiVersion);
            }
            progLogMsg = new VWString("vw.api.VWXMLConfiguration.readConfigurationFromString", "Import option: {0}\n\n", vstrImportMerge);
            progressLog.append(progLogMsg.toString());
            InputSource inSrc = new InputSource(inputXML);
            Document doc = XMLHelper.parseDocumentViaDOM(inSrc, new VWResolver(), new VWXMLErrorHandler(), false);
            Element configEle = doc.getDocumentElement();
            if (!VWXMLConfiguration.validateConfigurationXML(doc, configEle)) {
                throw new VWException("vw.api.VWXMLConfigurationInvalidXMLDocument", "Invalid configuration XML document");
            }
            apiVersion = configEle.getAttribute("ApiVersion");
            if (apiVersion == null || apiVersion.length() <= 0) {
                throw new VWException("vw.api.VWXMLConfigurationInvalidXMLDocument", "Invalid configuration XML document");
            }
            NodeList sysConfigList = configEle.getElementsByTagName("SystemConfiguration");
            if (sysConfigList != null && sysConfigList.getLength() > 0) {
                if (sysConfigList.getLength() > 1) {
                    throw new VWException("vw.api.VWXMLConfigurationMultipleSysConfig", "Multiple system configurations detected in XML document");
                }
                VWXMLConfiguration.importSystemConfiguration(sysConfig, sysConfigList, session, 2, progressLog);
            } else {
                NodeList otherNodes = configEle.getChildNodes();
                if (otherNodes != null && otherNodes.getLength() > 0) {
                    VWXMLConfiguration.importConfigurationChildElements(otherNodes, sysConfig, session, 2, progressLog);
                }
            }
        }
        catch (Exception ex) {
            VWException vwex = new VWException("vw.api.VWXMLConfigurationReadError", "The isolated region configuration information could not be read. The error occurred while attempting to read: {0}. \nEnsure valid XML is specified for the input stream.", ex.getMessage());
            vwex.setCause(ex);
            throw vwex;
        }
        progLogMsg = new VWString("vw.api.VWXMLConfiguration.readConfigurationFromStringEnd", "\nConfiguration information read successfully.\n\n");
        progressLog.append(progLogMsg.toString());
        if (logger.isFinest()) {
            logger.finest("*** Exiting parseConfigurationXML ***");
        }
        return progressLog;
    }

    protected static void importSystemConfiguration(VWSystemConfiguration sysConfig, NodeList sysConfigList, VWSession session, int option, StringBuffer progressLog) throws Exception {
        String str5;
        String str4;
        String str3;
        if (sysConfigList.getLength() == 0) {
            return;
        }
        if (sysConfig == null) {
            throw new VWException("vw.api.VWXMLConfigurationSysConfigNull", "The SystemConfiguration object is null.");
        }
        if (logger.isFinest()) {
            logger.finest("importSystemConfiguration enter-- option=" + option);
        }
        boolean bReplace = (option & 0xF) == 1;
        Element systemConfigEle = (Element)sysConfigList.item(0);
        if (bReplace) {
            String str2;
            String str1 = systemConfigEle.getAttribute("MaxDBOperations");
            if (str1 != null && str1.length() > 0) {
                int maxDBOperation = Integer.parseInt(str1);
                sysConfig.setMaxDBOperations(maxDBOperation);
            }
            if ((str2 = systemConfigEle.getAttribute("MaxInstructions")) != null && str2.length() > 0) {
                int maxInstructions = Integer.parseInt(str2);
                sysConfig.setMaxInstructions(maxInstructions);
            }
        }
        if ((str3 = systemConfigEle.getAttribute("LoggingState")) != null && str3.length() > 0) {
            int loggingState = Integer.parseInt(str3);
            if (bReplace) {
                sysConfig.setLoggingState(0, true);
            } else {
                loggingState |= sysConfig.getLoggingState();
            }
            sysConfig.setLoggingState(loggingState, true);
        }
        if ((str4 = systemConfigEle.getAttribute("StatisticsCollection")) != null && str4.length() > 0) {
            boolean bStatisticCollection = VWXMLHandler.stringToBoolean(str4);
            if (!bReplace) {
                bStatisticCollection |= sysConfig.getStatisticsCollection();
            }
            sysConfig.setStatisticsCollection(bStatisticCollection);
        }
        if ((str5 = systemConfigEle.getAttribute("TrackingAttachment")) != null && str5.length() > 0) {
            boolean bTrackingAttachment = VWXMLHandler.stringToBoolean(str5);
            if (!bReplace) {
                bTrackingAttachment |= sysConfig.getTrackAttachmentReferences();
            }
            sysConfig.setTrackAttachmentReferences(bTrackingAttachment);
        }
        NodeList childNodes = systemConfigEle.getChildNodes();
        VWXMLConfiguration.importConfigurationChildElements(childNodes, sysConfig, session, option, progressLog);
        if (logger.isFinest()) {
            logger.finest("importSystemConfiguration -- ");
        }
    }

    protected static void importConfigurationChildElements(NodeList childNodes, VWSystemConfiguration sysConfig, VWSession session, int option, StringBuffer progressLog) throws Exception {
        if (childNodes == null || childNodes.getLength() <= 0) {
            return;
        }
        Node appSpaceNode = null;
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node aNode = childNodes.item(i);
            String nodeName = aNode.getNodeName();
            if (nodeName.equals("ModelAttributes")) {
                Hashtable attributes = VWXMLConfiguration.parseXMLModelAttributes(aNode, apiVersion);
                if ((option & 0xF) == 2) {
                    VWAttributeInfo theAttributeInfo = VWXMLConfiguration.mergeAttributes(session, sysConfig.getAttributeInfo(), attributes);
                    sysConfig.setAttributeInfo(theAttributeInfo);
                    continue;
                }
                Hashtable revisedAttributes = VWXMLConfiguration.reviseXMLModelAttributes(session, attributes);
                sysConfig.setAttributes(revisedAttributes);
                continue;
            }
            if (nodeName.equals("LogDefinition")) {
                VWXMLConfiguration.importXMLLogDefinition(aNode, sysConfig, session, option, progressLog);
                continue;
            }
            if (nodeName.equals("ArrayOfLogDefinition")) {
                VWXMLConfiguration.importXMLLogDefinitionArray(aNode, sysConfig, session, option, progressLog);
                continue;
            }
            if (nodeName.equals("QueueDefinition")) {
                VWXMLConfiguration.importXMLQueueDefinition(aNode, sysConfig, session, option, progressLog);
                continue;
            }
            if (nodeName.equals("ArrayOfQueueDefinition")) {
                VWXMLConfiguration.importXMLQueueDefinitionArray(aNode, sysConfig, session, option, progressLog);
                continue;
            }
            if (nodeName.equals("RosterDefinition")) {
                VWXMLConfiguration.importXMLRosterDefinition(aNode, sysConfig, session, option, progressLog);
                continue;
            }
            if (nodeName.equals("ArrayOfRosterDefinition")) {
                VWXMLConfiguration.importXMLRosterDefinitionArray(aNode, sysConfig, session, option, progressLog);
                continue;
            }
            if (nodeName.equals("ArrayOfApplicationSpaceDefinition")) {
                appSpaceNode = aNode;
                continue;
            }
            if (nodeName.equals("StepProcessorInfoDefinition")) {
                VWXMLConfiguration.importXMLStepProcessorInfoDefinition(aNode, sysConfig, option, progressLog);
                continue;
            }
            if (!nodeName.equals("ArrayOfStepProcessorInfoDefinition")) continue;
            VWXMLConfiguration.importXMLStepProcessorInfoDefinitionArray(aNode, sysConfig, option, progressLog);
        }
        if (appSpaceNode != null) {
            VWXMLConfiguration.importXMLApplicationSpaceDefinitionArray(appSpaceNode, sysConfig, session, option, progressLog);
        }
    }

    protected static void importXMLExposedFieldDefinitionArray(Node aExposedFieldNode, VWTableDefinition aTblDef, int option) throws VWException {
        VWExposedFieldDefinition[] importedExposedFieldDefs = VWXMLConfiguration.parseXMLExposedFieldDefinitionArray(aExposedFieldNode);
        if (importedExposedFieldDefs != null && importedExposedFieldDefs.length > 0) {
            int sz;
            Vector<VWExposedFieldDefinition> colObjects = new Vector<VWExposedFieldDefinition>();
            VWExposedFieldDefinition[] theOrigExposedFieldDefs = aTblDef.getFields();
            if (theOrigExposedFieldDefs != null && theOrigExposedFieldDefs.length > 0) {
                VWIndexDefinition[] theOrigIndexDefs;
                if ((option & 0xF) == 1 && (theOrigIndexDefs = aTblDef.getIndexes()) != null && theOrigIndexDefs.length > 0) {
                    for (int i = 0; i < theOrigIndexDefs.length; ++i) {
                        if (theOrigIndexDefs[i].isMandatorySystemIndex()) continue;
                        aTblDef.deleteIndexDefinition(theOrigIndexDefs[i].getName());
                    }
                }
                for (int i = 0; i < importedExposedFieldDefs.length; ++i) {
                    String name = importedExposedFieldDefs[i].getName();
                    boolean bFound = false;
                    int foundIndex = 0;
                    for (int j = 0; j < theOrigExposedFieldDefs.length; ++j) {
                        if (!name.equals(theOrigExposedFieldDefs[j].getName())) continue;
                        bFound = true;
                        foundIndex = j;
                        break;
                    }
                    if (bFound) {
                        if (importedExposedFieldDefs[i].isMandatorySystemField()) continue;
                        if ((option & 0xF) == 2) {
                            if (importedExposedFieldDefs[i].getFieldType() != theOrigExposedFieldDefs[foundIndex].getFieldType()) {
                                throw new VWException("vw.api.VWXMLConfigurationExpFieldMismatch", "The type of exposed field {0} does not match existing exposed field type.", name);
                            }
                            if (importedExposedFieldDefs[i].getFieldType() != 2 || importedExposedFieldDefs[i].getLength() <= theOrigExposedFieldDefs[foundIndex].getLength()) continue;
                            theOrigExposedFieldDefs[foundIndex].setLength(importedExposedFieldDefs[i].getLength());
                            continue;
                        }
                        aTblDef.deleteFieldDefinition(name);
                        colObjects.add(importedExposedFieldDefs[i]);
                        continue;
                    }
                    colObjects.add(importedExposedFieldDefs[i]);
                }
            }
            if ((sz = colObjects.size()) > 0) {
                Object[] newDefs = new VWExposedFieldDefinition[sz];
                colObjects.copyInto(newDefs);
                for (int i = 0; i < newDefs.length; ++i) {
                    ((VWExposedFieldDefinition)newDefs[i]).setHasChanged(true);
                }
                aTblDef.createFieldDefinitions((VWExposedFieldDefinition[])newDefs);
            }
        }
    }

    protected static void importXMLIndexDefinitionArray(Node aIndexNode, VWTableDefinition aTblDef, int option) throws VWException {
        VWIndexDefinition[] importedIndexDefs = VWXMLConfiguration.parseXMLIndexDefinitionArray(aIndexNode, aTblDef);
        if (importedIndexDefs != null && importedIndexDefs.length > 0) {
            Vector<VWIndexDefinition> colObjects = new Vector<VWIndexDefinition>();
            VWIndexDefinition[] theOrigIndexDefs = aTblDef.getIndexes();
            int nOrigIndexDefCount = theOrigIndexDefs != null ? theOrigIndexDefs.length : 0;
            for (int i = 0; i < importedIndexDefs.length; ++i) {
                String name = importedIndexDefs[i].getName();
                int foundIndex = -1;
                for (int j = 0; j < nOrigIndexDefCount; ++j) {
                    if (!name.equals(theOrigIndexDefs[j].getName())) continue;
                    foundIndex = j;
                    break;
                }
                if (foundIndex != -1) {
                    if (theOrigIndexDefs[foundIndex].isSystemIndex()) continue;
                    if ((option & 0xF) == 2) {
                        String[] origFieldNames = theOrigIndexDefs[foundIndex].getFieldNames();
                        String[] importedFieldNames = importedIndexDefs[i].getFieldNames();
                        Vector<String> newFields = new Vector<String>(Arrays.asList(origFieldNames));
                        for (int importIndex = 0; importedFieldNames != null && importIndex < importedFieldNames.length; ++importIndex) {
                            boolean found = false;
                            for (int origIndex = 0; origFieldNames != null && origIndex < origFieldNames.length; ++origIndex) {
                                if (!importedFieldNames[importIndex].equals(origFieldNames[origIndex])) continue;
                                found = true;
                                break;
                            }
                            if (found) continue;
                            newFields.add(importedFieldNames[importIndex]);
                        }
                        theOrigIndexDefs[foundIndex].setFieldNames(newFields.toArray(new String[0]));
                        continue;
                    }
                    aTblDef.deleteIndexDefinition(name);
                    colObjects.add(importedIndexDefs[i]);
                    continue;
                }
                colObjects.add(importedIndexDefs[i]);
            }
            int sz = colObjects.size();
            if (sz > 0) {
                Object[] newDefs = new VWIndexDefinition[sz];
                colObjects.copyInto(newDefs);
                for (int i = 0; i < newDefs.length; ++i) {
                    ((VWIndexDefinition)newDefs[i]).setHasChanged(true);
                }
                aTblDef.createIndexDefinitions((VWIndexDefinition[])newDefs);
            }
        }
    }

    protected static void importXMLLogDefinition(Node aLogNode, VWSystemConfiguration sysConfig, VWSession session, int option, StringBuffer progressLog) throws VWException, SAXException, NumberFormatException {
        if (aLogNode == null) {
            throw new VWException("vw.api.VWXMLConfigurationNullNode", "DOM Node parameter is null");
        }
        Element logDefElem = (Element)aLogNode;
        String sLogName = logDefElem.getAttribute("Name");
        String sDesc = logDefElem.getAttribute("Description");
        VWLogDefinition aLogDef = null;
        if (logger.isFinest()) {
            logger.finest("importXMLLogDefinition enter -- log name=" + sLogName + " option=" + option);
        }
        VWString progLogMsg = new VWString("vw.api.VWXMLConfiguration.importXMLLogDefinition", "Import event log \"{0}\"\n");
        progressLog.append(progLogMsg.toString(sLogName));
        aLogDef = sysConfig.getLogDefinition(sLogName) == null ? sysConfig.createLogDefinition(sLogName) : ((option & 0xF) == 2 ? sysConfig.getLogDefinition(sLogName) : sysConfig.constructDefaultLogDef(sLogName));
        aLogDef.setDescription(sDesc);
        NodeList childNodes = logDefElem.getChildNodes();
        int childNodeCount = childNodes.getLength();
        for (int i = 0; i < childNodeCount; ++i) {
            Node aChildNode = childNodes.item(i);
            String nodeName = aChildNode.getNodeName();
            if (nodeName.equals("ArrayOfExposedFieldDefinition")) {
                VWXMLConfiguration.importXMLExposedFieldDefinitionArray(aChildNode, aLogDef, option);
                continue;
            }
            if (nodeName.equals("ArrayOfIndexDefinition")) {
                VWXMLConfiguration.importXMLIndexDefinitionArray(aChildNode, aLogDef, option);
                continue;
            }
            if (nodeName.equals("ReadSecurity")) {
                Object[] readSecurity = VWXMLConfiguration.parseXMLSecurityList(aChildNode, session, progressLog);
                if ((option & 0xF) == 2) {
                    readSecurity = VWXMLConfiguration.mergeArrays(readSecurity, aLogDef.getReadSecurity());
                }
                aLogDef.setReadSecurity((String[])readSecurity);
                continue;
            }
            if (!nodeName.equals("WriteSecurity")) continue;
            Object[] writeSecurity = VWXMLConfiguration.parseXMLSecurityList(aChildNode, session, progressLog);
            if ((option & 0xF) == 2) {
                writeSecurity = VWXMLConfiguration.mergeArrays(writeSecurity, aLogDef.getWriteSecurity());
            }
            aLogDef.setWriteSecurity((String[])writeSecurity);
        }
        aLogDef.setHasChanged(true);
        sysConfig.updateLogDefinition(aLogDef);
        progLogMsg = new VWString("vw.api.VWXMLConfiguration.importXMLLogDefinitionEnd", "Import event log \"{0}\" succeeded\n");
        progressLog.append(progLogMsg.toString(sLogName));
        if (logger.isFinest()) {
            logger.finest("importXMLLogDefinition -- log name=" + sLogName);
        }
    }

    protected static void importXMLLogDefinitionArray(Node arrayNode, VWSystemConfiguration sysConfig, VWSession session, int option, StringBuffer progressLog) throws VWException, SAXException, NumberFormatException {
        if (arrayNode == null) {
            throw new VWException("vw.api.VWXMLConfigurationNullNode", "DOM Node parameter is null");
        }
        if (!arrayNode.getNodeName().equals("ArrayOfLogDefinition")) {
            throw new VWException("vw.api.VWXMLConfigurationInvalidNode", "Node parameter is not {0}", "ArrayOfLogDefinition");
        }
        if (!arrayNode.hasChildNodes()) {
            return;
        }
        NodeList logDefNodeList = ((Element)arrayNode).getElementsByTagName("LogDefinition");
        if (logDefNodeList == null) {
            return;
        }
        int childNodeCount = logDefNodeList.getLength();
        for (int i = 0; i < childNodeCount; ++i) {
            VWXMLConfiguration.importXMLLogDefinition(logDefNodeList.item(i), sysConfig, session, option, progressLog);
        }
    }

    protected static void importXMLOperationDefinition(Node aOpDefNode, VWQueueDefinition theQueue, int option) throws Exception {
        if (aOpDefNode == null) {
            throw new VWException("vw.api.VWXMLConfigurationNullNode", "DOM Node parameter is null");
        }
        Element opDefElem = (Element)aOpDefNode;
        String sOpName = opDefElem.getAttribute("Name");
        String sOpDesc = opDefElem.getAttribute("Description");
        if (logger.isFinest()) {
            logger.finest("importXMLOperationDefinition enter -- name=" + sOpName);
        }
        VWParameterDefinition[] arrayParamDef = null;
        Hashtable attributes = null;
        NodeList childNodes = opDefElem.getChildNodes();
        int childNodeCount = childNodes.getLength();
        for (int i = 0; i < childNodeCount; ++i) {
            Node aChildNode = childNodes.item(i);
            String nodeName = aChildNode.getNodeName();
            if (nodeName.equals("ArrayOfParameterDefinition")) {
                arrayParamDef = VWXMLConfiguration.parseXMLParameterDefinitionArray(aChildNode);
                continue;
            }
            if (!nodeName.equals("ModelAttributes")) continue;
            attributes = VWXMLConfiguration.parseXMLModelAttributes(aChildNode, apiVersion);
        }
        VWOperationDefinition aOpDef = null;
        try {
            aOpDef = theQueue.getOperation(sOpName);
        }
        catch (VWException e) {
            // empty catch block
        }
        if (aOpDef == null || (option & 0xF) == 1) {
            if (aOpDef != null) {
                theQueue.deleteOperation(sOpName);
            }
            aOpDef = theQueue.createOperation(sOpName);
            aOpDef.setDescription(sOpDesc);
            if (arrayParamDef != null) {
                for (int j = 0; j < arrayParamDef.length; ++j) {
                    aOpDef.createParameter(arrayParamDef[j]);
                }
            }
            if (attributes != null) {
                aOpDef.setAttributes(attributes);
            }
        }
        if (logger.isFinest()) {
            logger.finest("importXMLOperationDefinition -- ");
        }
    }

    protected static void importXMLOperationDefinitionArray(Node arrayOperationNode, VWQueueDefinition queueDef, int option) throws Exception {
        if (arrayOperationNode == null) {
            throw new VWException("vw.api.VWXMLConfigurationNullNode", "DOM Node parameter is null");
        }
        if (!arrayOperationNode.getNodeName().equals("ArrayOfOperationDefinition")) {
            throw new VWException("vw.api.VWXMLConfigurationInvalidNode", "Node parameter is not {0}", "ArrayOfOperationDefinition");
        }
        if (!arrayOperationNode.hasChildNodes()) {
            return;
        }
        NodeList opDefNodeList = ((Element)arrayOperationNode).getElementsByTagName("OperationDefinition");
        if (opDefNodeList == null) {
            return;
        }
        int childNodeCount = opDefNodeList.getLength();
        for (int i = 0; i < childNodeCount; ++i) {
            VWXMLConfiguration.importXMLOperationDefinition(opDefNodeList.item(i), queueDef, option);
        }
    }

    protected static void importXMLQueueDefinition(Node aQueueNode, VWSystemConfiguration sysConfig, VWSession session, int option, StringBuffer progressLog) throws Exception {
        if (aQueueNode == null) {
            throw new VWException("vw.api.VWXMLConfigurationNullNode", "DOM Node parameter is null");
        }
        Element queueDefElem = (Element)aQueueNode;
        String sQueueName = queueDefElem.getAttribute("Name");
        if (logger.isFinest()) {
            logger.finest("importXMLQueueDefinition enter-- queue name=" + sQueueName + ", option=" + option);
        }
        VWString progLogMsg = new VWString("vw.api.VWXMLConfiguration.importXMLQueueDefinition", "Import queue \"{0}\"\n");
        progressLog.append(progLogMsg.toString(sQueueName));
        int queueType = 1;
        String sQueueType = queueDefElem.getAttribute("Type");
        if (sQueueType != null && sQueueType.length() > 0) {
            queueType = Integer.parseInt(sQueueType);
        }
        VWQueueDefinition aQueueDef = null;
        aQueueDef = sysConfig.getQueueDefinition(sQueueName) == null ? sysConfig.createQueueDefinition(sQueueName, queueType) : ((option & 0xF) == 2 ? sysConfig.getQueueDefinition(sQueueName) : sysConfig.constructDefaultQueueDef(sQueueName, queueType));
        String str2 = queueDefElem.getAttribute("IsConnectorQueue");
        if (str2 != null && str2.length() > 0) {
            boolean bIsConnectorQueue = VWXMLHandler.stringToBoolean(str2);
            aQueueDef.setIsConnectorQueue(bIsConnectorQueue);
        }
        String sDesc = queueDefElem.getAttribute("Description");
        aQueueDef.setDescription(sDesc);
        NodeList childNodes = queueDefElem.getChildNodes();
        int childNodeCount = childNodes.getLength();
        Node aWorkBasketArrayNode = null;
        for (int i = 0; i < childNodeCount; ++i) {
            Node aChildNode = childNodes.item(i);
            String nodeName = aChildNode.getNodeName();
            if (nodeName.equals("ArrayOfExposedFieldDefinition")) {
                VWXMLConfiguration.importXMLExposedFieldDefinitionArray(aChildNode, aQueueDef, option);
                continue;
            }
            if (nodeName.equals("ArrayOfIndexDefinition")) {
                VWXMLConfiguration.importXMLIndexDefinitionArray(aChildNode, aQueueDef, option);
                continue;
            }
            if (nodeName.equals("ArrayOfOperationDefinition")) {
                VWXMLConfiguration.importXMLOperationDefinitionArray(aChildNode, aQueueDef, option);
                continue;
            }
            if (nodeName.equals("ArrayOfInBasketDefinition")) {
                aWorkBasketArrayNode = aChildNode;
                continue;
            }
            if (nodeName.equals("ModelAttributes")) {
                Hashtable attributes = VWXMLConfiguration.parseXMLModelAttributes(aChildNode, apiVersion);
                if ((option & 0xF) == 2) {
                    VWAttributeInfo theAttributeInfo = VWXMLConfiguration.mergeAttributes(session, aQueueDef.getAttributeInfo(), attributes);
                    aQueueDef.setAttributeInfo(theAttributeInfo);
                    continue;
                }
                aQueueDef.setAttributes(attributes);
                continue;
            }
            if (nodeName.equals("ReadSecurity")) {
                Object[] readSecurity = VWXMLConfiguration.parseXMLSecurityList(aChildNode, session, progressLog);
                if ((option & 0xF) == 2) {
                    readSecurity = VWXMLConfiguration.mergeArrays(readSecurity, aQueueDef.getReadSecurity());
                }
                aQueueDef.setReadSecurity((String[])readSecurity);
                continue;
            }
            if (!nodeName.equals("WriteSecurity")) continue;
            Object[] writeSecurity = VWXMLConfiguration.parseXMLSecurityList(aChildNode, session, progressLog);
            if ((option & 0xF) == 2) {
                writeSecurity = VWXMLConfiguration.mergeArrays(writeSecurity, aQueueDef.getWriteSecurity());
            }
            aQueueDef.setWriteSecurity((String[])writeSecurity);
        }
        if (aWorkBasketArrayNode != null) {
            VWXMLConfiguration.importXMLWorkBasketDefinitionArray(aWorkBasketArrayNode, aQueueDef, session, option, progressLog);
        }
        aQueueDef.setHasChanged(true);
        sysConfig.updateQueueDefinition(aQueueDef);
        progLogMsg = new VWString("vw.api.VWXMLConfiguration.importXMLQueueDefinitionEnd", "Import queue \"{0}\" succeeded\n\n");
        progressLog.append(progLogMsg.toString(sQueueName));
        if (logger.isFinest()) {
            logger.finest("importXMLQueueDefinition --");
        }
    }

    protected static void importXMLQueueDefinitionArray(Node arrayNode, VWSystemConfiguration sysConfig, VWSession session, int option, StringBuffer progressLog) throws Exception {
        if (arrayNode == null) {
            throw new VWException("vw.api.VWXMLConfigurationNullNode", "DOM Node parameter is null");
        }
        if (!arrayNode.getNodeName().equals("ArrayOfQueueDefinition")) {
            throw new VWException("vw.api.VWXMLConfigurationInvalidNode", "Node parameter is not {0}", "ArrayOfQueueDefinition");
        }
        if (!arrayNode.hasChildNodes()) {
            return;
        }
        NodeList queueDefNodeList = ((Element)arrayNode).getElementsByTagName("QueueDefinition");
        if (queueDefNodeList == null) {
            return;
        }
        int childNodeCount = queueDefNodeList.getLength();
        for (int i = 0; i < childNodeCount; ++i) {
            VWXMLConfiguration.importXMLQueueDefinition(queueDefNodeList.item(i), sysConfig, session, option, progressLog);
        }
    }

    protected static void importXMLRosterDefinition(Node aRosterNode, VWSystemConfiguration sysConfig, VWSession session, int option, StringBuffer progressLog) throws VWException, SAXException, NumberFormatException {
        if (aRosterNode == null) {
            throw new VWException("vw.api.VWXMLConfigurationNullNode", "DOM Node parameter is null");
        }
        Element rosterDefElem = (Element)aRosterNode;
        String sRosterName = rosterDefElem.getAttribute("Name");
        String sDesc = rosterDefElem.getAttribute("Description");
        if (logger.isFinest()) {
            logger.finest("importXMLRosterDefinition enter -- name=" + sRosterName);
        }
        VWString progLogMsg = new VWString("vw.api.VWXMLConfiguration.importXMLRosterDefinition", "Import roster \"{0}\"\n");
        progressLog.append(progLogMsg.toString(sRosterName));
        VWRosterDefinition aRosterDef = null;
        aRosterDef = sysConfig.getRosterDefinition(sRosterName) == null ? sysConfig.createRosterDefinition(sRosterName) : ((option & 0xF) == 2 ? sysConfig.getRosterDefinition(sRosterName) : sysConfig.constructDefaultRosterDef(sRosterName));
        aRosterDef.setDescription(sDesc);
        NodeList childNodes = rosterDefElem.getChildNodes();
        int childNodeCount = childNodes.getLength();
        for (int i = 0; i < childNodeCount; ++i) {
            Node aChildNode = childNodes.item(i);
            String nodeName = aChildNode.getNodeName();
            if (nodeName.equals("ArrayOfExposedFieldDefinition")) {
                VWXMLConfiguration.importXMLExposedFieldDefinitionArray(aChildNode, aRosterDef, option);
                continue;
            }
            if (nodeName.equals("ArrayOfIndexDefinition")) {
                VWXMLConfiguration.importXMLIndexDefinitionArray(aChildNode, aRosterDef, option);
                continue;
            }
            if (nodeName.equals("ReadSecurity")) {
                Object[] readSecurity = VWXMLConfiguration.parseXMLSecurityList(aChildNode, session, progressLog);
                if ((option & 0xF) == 2) {
                    readSecurity = VWXMLConfiguration.mergeArrays(readSecurity, aRosterDef.getReadSecurity());
                }
                aRosterDef.setReadSecurity((String[])readSecurity);
                continue;
            }
            if (nodeName.equals("WriteSecurity")) {
                Object[] writeSecurity = VWXMLConfiguration.parseXMLSecurityList(aChildNode, session, progressLog);
                if ((option & 0xF) == 2) {
                    writeSecurity = VWXMLConfiguration.mergeArrays(writeSecurity, aRosterDef.getWriteSecurity());
                }
                aRosterDef.setWriteSecurity((String[])writeSecurity);
                continue;
            }
            if (!nodeName.equals("CreateSecurity")) continue;
            Object[] createSecurity = VWXMLConfiguration.parseXMLSecurityList(aChildNode, session, progressLog);
            if ((option & 0xF) == 2) {
                createSecurity = VWXMLConfiguration.mergeArrays(createSecurity, aRosterDef.getCreateSecurity());
            }
            aRosterDef.setCreateSecurity((String[])createSecurity);
        }
        aRosterDef.setHasChanged(true);
        sysConfig.updateRosterDefinition(aRosterDef);
        progLogMsg = new VWString("vw.api.VWXMLConfiguration.importXMLRosterDefinitionEnd", "Import roster \"{0}\" succeeded\n\n");
        progressLog.append(progLogMsg.toString(sRosterName));
        if (logger.isFinest()) {
            logger.finest("importXMLRosterDefinition --");
        }
    }

    protected static void importXMLRosterDefinitionArray(Node arrayNode, VWSystemConfiguration sysConfig, VWSession session, int option, StringBuffer progressLog) throws VWException, SAXException, NumberFormatException {
        if (arrayNode == null) {
            throw new VWException("vw.api.VWXMLConfigurationNullNode", "DOM Node parameter is null");
        }
        if (!arrayNode.getNodeName().equals("ArrayOfRosterDefinition")) {
            throw new VWException("vw.api.VWXMLConfigurationInvalidNode", "Node parameter is not {0}", "ArrayOfRosterDefinition");
        }
        if (!arrayNode.hasChildNodes()) {
            return;
        }
        NodeList rosterDefNodeList = ((Element)arrayNode).getElementsByTagName("RosterDefinition");
        if (rosterDefNodeList == null) {
            return;
        }
        int childNodeCount = rosterDefNodeList.getLength();
        for (int i = 0; i < childNodeCount; ++i) {
            VWXMLConfiguration.importXMLRosterDefinition(rosterDefNodeList.item(i), sysConfig, session, option, progressLog);
        }
    }

    protected static void importXMLApplicationSpaceDefinition(Node anAppSpaceNode, VWSystemConfiguration sysConfig, VWSession session, int option, StringBuffer progressLog) throws Exception {
        if (anAppSpaceNode == null) {
            throw new VWException("vw.api.VWXMLConfigurationNullNode", "DOM Node parameter is null");
        }
        Element appSpaceDefElem = (Element)anAppSpaceNode;
        String sAppSpaceName = appSpaceDefElem.getAttribute("Name");
        String sDesc = appSpaceDefElem.getAttribute("Description");
        if (logger.isFinest()) {
            logger.finest("importXMLRosterDefinition enter -- name=" + sAppSpaceName);
        }
        boolean bMerge = false;
        VWString progLogMsg = new VWString("vw.api.VWXMLConfiguration.importXMLApplicationSpaceDefinition", "Import applicaition space \"{0}\"\n");
        progressLog.append(progLogMsg.toString(sAppSpaceName));
        VWApplicationSpaceDefinition anAppSpaceDef = null;
        if (sysConfig.getApplicationSpaceDefinition(sAppSpaceName) == null) {
            anAppSpaceDef = sysConfig.createApplicationSpaceDefinition(sAppSpaceName);
        } else if ((option & 0xF) == 2) {
            anAppSpaceDef = sysConfig.getApplicationSpaceDefinition(sAppSpaceName);
            bMerge = true;
        } else {
            anAppSpaceDef = new VWApplicationSpaceDefinition(0, sAppSpaceName, null);
        }
        if (!bMerge || anAppSpaceDef.getDescription() == null || anAppSpaceDef.getDescription().trim().length() == 0) {
            anAppSpaceDef.setDescription(sDesc);
        }
        NodeList childNodes = appSpaceDefElem.getChildNodes();
        int childNodeCount = childNodes.getLength();
        for (int i = 0; i < childNodeCount; ++i) {
            Node aChildNode = childNodes.item(i);
            String nodeName = aChildNode.getNodeName();
            if (nodeName.equals("ArrayOfRoleDefinition")) {
                VWXMLConfiguration.importXMLRoleDefinitionArray(aChildNode, anAppSpaceDef, sysConfig, session, option, progressLog);
                continue;
            }
            if (nodeName.equals("ModelAttributes")) {
                Hashtable attributes = VWXMLConfiguration.parseXMLModelAttributes(aChildNode, apiVersion);
                if (bMerge) {
                    VWAttributeInfo theAttributeInfo = VWXMLConfiguration.mergeAttributes(session, anAppSpaceDef.getAttributeInfo(), attributes);
                    anAppSpaceDef.setAttributeInfo(theAttributeInfo);
                    continue;
                }
                anAppSpaceDef.setAttributes(attributes);
                continue;
            }
            if (!nodeName.equals("WriteSecurity")) continue;
            Object[] writeSecurity = VWXMLConfiguration.parseXMLSecurityList(aChildNode, session, progressLog);
            if (bMerge) {
                writeSecurity = VWXMLConfiguration.mergeArrays(writeSecurity, anAppSpaceDef.getWriteSecurity());
            }
            anAppSpaceDef.m_writeSecurity = writeSecurity;
        }
        anAppSpaceDef.setHasChanged(true);
        sysConfig.updateApplicationSpaceDefinition(anAppSpaceDef);
        progLogMsg = new VWString("vw.api.VWXMLConfiguration.importXMLApplicationSpaceDefinitionEnd", "Import application space \"{0}\" succeeded\n\n");
        progressLog.append(progLogMsg.toString(sAppSpaceName));
        if (logger.isFinest()) {
            logger.finest("importXMLApplicationSpaceDefinition --");
        }
    }

    protected static void importXMLApplicationSpaceDefinitionArray(Node arrayNode, VWSystemConfiguration sysConfig, VWSession session, int option, StringBuffer progressLog) throws Exception {
        if (arrayNode == null) {
            throw new VWException("vw.api.VWXMLConfiguration.ApplicationSpaceDefNullNode", "DOM Node parameter is null");
        }
        if (!arrayNode.getNodeName().equals("ArrayOfApplicationSpaceDefinition")) {
            throw new VWException("vw.api.VWXMLConfiguration.ApplicationSpaceDefInvalidNode", "Node parameter is not {0}", "ArrayOfApplicationSpaceDefinition");
        }
        if (!arrayNode.hasChildNodes()) {
            return;
        }
        NodeList asDefNodeList = ((Element)arrayNode).getElementsByTagName("ApplicationSpaceDefinition");
        if (asDefNodeList == null) {
            return;
        }
        int childNodeCount = asDefNodeList.getLength();
        for (int i = 0; i < childNodeCount; ++i) {
            VWXMLConfiguration.importXMLApplicationSpaceDefinition(asDefNodeList.item(i), sysConfig, session, option, progressLog);
        }
    }

    protected static void importXMLRoleDefinition(Node aRoleNode, VWApplicationSpaceDefinition appSpaceDef, VWSystemConfiguration sysConfig, VWSession session, int option, StringBuffer progressLog) throws Exception {
        String homePageURL;
        if (aRoleNode == null) {
            throw new VWException("vw.api.VWXMLConfiguration.RoleDefinitoinNullNode", "DOM Node parameter is null");
        }
        Element roleDefElem = (Element)aRoleNode;
        String sRoleName = roleDefElem.getAttribute("Name");
        String sDesc = roleDefElem.getAttribute("Description");
        if (logger.isFinest()) {
            logger.finest("importXMLRoleDefinition enter -- name=" + sRoleName);
        }
        VWString progLogMsg = new VWString("vw.api.VWXMLConfiguration.importXMLRoleDefinition", "Import role definition \"{0}\"\n");
        progressLog.append(progLogMsg.toString(sRoleName));
        boolean bMerge = false;
        VWRoleDefinition roleDef = null;
        if (appSpaceDef.getRoleDefinition(sRoleName) == null) {
            roleDef = appSpaceDef.createRoleDefinition(sRoleName);
            roleDef.setMyApplicationSpaceDefinition(appSpaceDef);
        } else if ((option & 0xF) == 2) {
            roleDef = appSpaceDef.getRoleDefinition(sRoleName);
            bMerge = true;
        } else {
            roleDef = appSpaceDef.getRoleDefinition(sRoleName);
            roleDef.reset();
        }
        roleDef.setDescription(sDesc);
        if (!(bMerge && roleDef.getHomePageURL() != null && roleDef.getHomePageURL().trim().length() != 0 || (homePageURL = roleDefElem.getAttribute("HomePageURL")) == null || homePageURL.length() <= 0)) {
            roleDef.setHomePageURL(homePageURL);
        }
        NodeList childNodes = roleDefElem.getChildNodes();
        int childNodeCount = childNodes.getLength();
        for (int i = 0; i < childNodeCount; ++i) {
            Node aChildNode = childNodes.item(i);
            String nodeName = aChildNode.getNodeName();
            if (nodeName.equals("InBaskets")) {
                VWXMLConfiguration.importXMLWorkBasketReferenceArray(aChildNode, roleDef, sysConfig, option, progressLog);
                continue;
            }
            if (nodeName.equals("RoleParticipants")) {
                Object[] participants = VWXMLConfiguration.parseXMLSecurityList(aChildNode, session, progressLog);
                if (bMerge) {
                    participants = VWXMLConfiguration.mergeArrays(participants, roleDef.getRoleParticipantNames());
                }
                roleDef.setRoleParticipantByNames((String[])participants);
                continue;
            }
            if (!nodeName.equals("ModelAttributes")) continue;
            Hashtable attributes = VWXMLConfiguration.parseXMLModelAttributes(aChildNode, apiVersion);
            if (bMerge) {
                VWAttributeInfo theAttributeInfo = VWXMLConfiguration.mergeAttributes(session, roleDef.getAttributeInfo(), attributes);
                roleDef.setAttributeInfo(theAttributeInfo);
                continue;
            }
            roleDef.setAttributes(attributes);
        }
        roleDef.setHasChanged(true);
        appSpaceDef.updateRoleDefinition(roleDef);
        progLogMsg = new VWString("vw.api.VWXMLConfiguration.importXMLRoleDefinitionEnd", "Import role definition \"{0}\" succeeded\n");
        progressLog.append(progLogMsg.toString(roleDef));
        if (logger.isFinest()) {
            logger.finest("importXMLRoleDefinition --");
        }
    }

    protected static void importXMLRoleDefinitionArray(Node arrayNode, VWApplicationSpaceDefinition appSpaceDef, VWSystemConfiguration sysConfig, VWSession session, int option, StringBuffer progressLog) throws Exception {
        if (arrayNode == null) {
            throw new VWException("vw.api.VWXMLConfiguration.RoleDefinitionNullNode", "DOM Node parameter is null");
        }
        if (!arrayNode.getNodeName().equals("ArrayOfRoleDefinition")) {
            throw new VWException("vw.api.VWXMLConfiguration.RoleDefinitionInvalidNode", "Node parameter is not {0}", "ArrayOfRoleDefinition");
        }
        if (!arrayNode.hasChildNodes()) {
            return;
        }
        NodeList roleDefNodeList = ((Element)arrayNode).getElementsByTagName("RoleDefinition");
        if (roleDefNodeList == null) {
            return;
        }
        int childNodeCount = roleDefNodeList.getLength();
        for (int i = 0; i < childNodeCount; ++i) {
            VWXMLConfiguration.importXMLRoleDefinition(roleDefNodeList.item(i), appSpaceDef, sysConfig, session, option, progressLog);
        }
    }

    protected static void importXMLWorkBasketReferenceArray(Node arrayNode, VWRoleDefinition roleDef, VWSystemConfiguration sysConfig, int option, StringBuffer progressLog) throws Exception {
        if (arrayNode == null) {
            throw new VWException("vw.api.VWXMLConfiguration.RoleDefinitionNullNode", "DOM Node parameter is null");
        }
        if (!arrayNode.getNodeName().equals("InBaskets")) {
            throw new VWException("vw.api.VWXMLConfiguration.RoleDefinitionInvalidNode", "Node parameter is not {0}", "InBaskets");
        }
        if (!arrayNode.hasChildNodes()) {
            return;
        }
        NodeList inBasketNodeList = ((Element)arrayNode).getElementsByTagName("InBasket");
        if (inBasketNodeList == null) {
            return;
        }
        int childNodeCount = inBasketNodeList.getLength();
        if (childNodeCount <= 0) {
            return;
        }
        VWWorkBasketDefinition[] theRoleWBDefs = roleDef.getWorkBasketDefinitions();
        ArrayList<Object> workBasketsList = null;
        workBasketsList = (option & 0xF) == 2 && theRoleWBDefs != null && theRoleWBDefs.length > 0 ? new ArrayList<VWWorkBasketDefinition>(Arrays.asList(theRoleWBDefs)) : new ArrayList();
        for (int nNodeIndex = 0; nNodeIndex < childNodeCount; ++nNodeIndex) {
            if (inBasketNodeList.item(nNodeIndex) == null) continue;
            Element workBasketRefElem = (Element)inBasketNodeList.item(nNodeIndex);
            String sWorkBasketName = workBasketRefElem.getAttribute("Name");
            String sQueueName = workBasketRefElem.getAttribute("QueueName");
            if (sWorkBasketName == null || sWorkBasketName.trim().length() <= 0) continue;
            if (sQueueName != null && sQueueName.trim().length() > 0) {
                VWQueueDefinition queueDef = sysConfig.getQueueDefinition(sQueueName);
                if (queueDef != null) {
                    VWWorkBasketDefinition theQueueWBDef = queueDef.getWorkBasketDefinition(sWorkBasketName);
                    if (theQueueWBDef != null) {
                        if ((option & 0xF) == 2) {
                            boolean bFound = false;
                            for (int j = 0; j < workBasketsList.size(); ++j) {
                                VWWorkBasketDefinition aRoleWBDef = (VWWorkBasketDefinition)workBasketsList.get(j);
                                if (aRoleWBDef.getName().compareTo(theQueueWBDef.getName()) != 0 || aRoleWBDef.getQueueName().compareTo(theQueueWBDef.getQueueName()) != 0) continue;
                                bFound = true;
                                if (nNodeIndex == j) break;
                                workBasketsList.remove(j);
                                if (nNodeIndex > workBasketsList.size()) {
                                    workBasketsList.add(theQueueWBDef);
                                    break;
                                }
                                workBasketsList.add(nNodeIndex, theQueueWBDef);
                                break;
                            }
                            if (bFound) continue;
                            if (nNodeIndex > workBasketsList.size()) {
                                workBasketsList.add(theQueueWBDef);
                                continue;
                            }
                            workBasketsList.add(nNodeIndex, theQueueWBDef);
                            continue;
                        }
                        workBasketsList.add(theQueueWBDef);
                        continue;
                    }
                    if (logger.isFinest()) {
                        logger.finest("importXMLWorkBasketReferenceArray In-basket = " + sWorkBasketName + " for role -- the In-basket definition from queue definition = " + sQueueName + " does not exist.");
                    }
                    throw new VWException("vw.api.VWXMLConfiguration.importXMLWorkBasketReferenceArray.cantFindInBasketDef", "Failed to import In-basket \"{0}\" for role - the In-basket definition from the queue definition \"{1}\" does not exist.", sWorkBasketName, sQueueName);
                }
                if (logger.isFinest()) {
                    logger.finest("importXMLWorkBasketReferenceArray In-basket = " + sWorkBasketName + " for role -- the queue definition = " + sQueueName + " does not exist");
                }
                throw new VWException("vw.api.VWXMLConfiguration.importXMLWorkBasketReferenceArray.cantFindQueueDef", "Failed to import In-basket \"{0}\" for role - the queue definition \"{1}\" does not exist.", sWorkBasketName, sQueueName);
            }
            if (logger.isFinest()) {
                logger.finest("importXMLWorkBasketReferenceArray In-basket = " + sWorkBasketName + " for role -- missing the queue definition name");
            }
            throw new VWException("vw.api.VWXMLConfiguration.importXMLWorkBasketReferenceArray.missingQueueDefName", "Failed to import In-basket \"{0}\" for role - missing the queue definition name.", sWorkBasketName);
        }
        if (workBasketsList.size() > 0) {
            VWWorkBasketDefinition[] wbDefRefs = workBasketsList.toArray(new VWWorkBasketDefinition[workBasketsList.size()]);
            roleDef.setWorkBasketDefinitions(wbDefRefs);
        }
    }

    protected static void importXMLWorkBasketDefinition(Node aWorkBasketNode, VWQueueDefinition queueDef, VWSession session, int option, StringBuffer progressLog) throws Exception {
        String sFilterString;
        if (aWorkBasketNode == null) {
            throw new VWException("vw.api.VWXMLConfiguration.InBasketDefNullNode", "DOM Node parameter is null");
        }
        Element workBasketDefElem = (Element)aWorkBasketNode;
        String sWorkBasketName = workBasketDefElem.getAttribute("Name");
        String sDesc = workBasketDefElem.getAttribute("Description");
        if (logger.isFinest()) {
            logger.finest("importXMLWorkBasketDefinition enter -- name=" + sWorkBasketName);
        }
        VWString progLogMsg = new VWString("vw.api.VWXMLConfiguration.importXMLWorkBasketDefinition", "Import In-basket \"{0}\"\n");
        progressLog.append(progLogMsg.toString(sWorkBasketName));
        int nInbasketOptions = 1 | option & 0xF0;
        VWWorkBasketDefinition aWorkBasketDef = null;
        if (queueDef.getWorkBasketDefinition(sWorkBasketName) == null) {
            aWorkBasketDef = queueDef.createWorkBasketDefinition(sWorkBasketName);
        } else {
            aWorkBasketDef = queueDef.getWorkBasketDefinition(sWorkBasketName);
            aWorkBasketDef.reset();
        }
        if (aWorkBasketDef.getDescription() == null || aWorkBasketDef.getDescription().trim().length() == 0) {
            aWorkBasketDef.setDescription(sDesc);
        }
        if (aWorkBasketDef.getIndexName() == null || aWorkBasketDef.getIndexName().trim().length() == 0) {
            String sIndexName = workBasketDefElem.getAttribute("IndexName");
            if (sIndexName != null) {
                sIndexName = sIndexName.trim();
            }
            if (sIndexName != null && queueDef.getIndex(sIndexName) != null) {
                try {
                    aWorkBasketDef.setIndexName(sIndexName);
                }
                catch (VWException ex) {
                    if (logger.isFinest()) {
                        logger.finest("Failed to import index name -- " + ex.getLocalizedMessage());
                    }
                    progLogMsg = new VWString("vw.api.VWXMLConfiguration.importXMLWorkBasketDefinition.failedToImportIndexName", "Failed to import index name \"{0}\" -- " + ex.getLocalizedMessage() + "\n");
                    progressLog.append(progLogMsg.toString(sIndexName));
                }
            }
        }
        if ((aWorkBasketDef.getQueryFilterString() == null || aWorkBasketDef.getQueryFilterString().trim().length() == 0) && (sFilterString = workBasketDefElem.getAttribute("QueueFilterString")) != null) {
            aWorkBasketDef.setQueryFilterString(sFilterString);
        }
        NodeList childNodes = workBasketDefElem.getChildNodes();
        int childNodeCount = childNodes.getLength();
        for (int i = 0; i < childNodeCount; ++i) {
            Node aChildNode = childNodes.item(i);
            String nodeName = aChildNode.getNodeName();
            if (nodeName.equals("ArrayOfInBasketFilterDefinition")) {
                VWXMLConfiguration.importXMLWorkBasketFilterDefinitionArray(aChildNode, aWorkBasketDef, session, nInbasketOptions, progressLog);
            }
            if (nodeName.equals("ArrayOfInBasketColumnDefinition")) {
                VWXMLConfiguration.importXMLWorkBasketColumnDefinitionArray(aChildNode, aWorkBasketDef, session, nInbasketOptions, progressLog);
                continue;
            }
            if (!nodeName.equals("ModelAttributes")) continue;
            aWorkBasketDef.setAttributes(VWXMLConfiguration.parseXMLModelAttributes(aChildNode, apiVersion));
        }
        aWorkBasketDef.setHasChanged(true);
        progLogMsg = new VWString("vw.api.VWXMLConfiguration.importXMLWorkBasketDefinition.successful", "Import In-basket \"{0}\" succeeded\n");
        progressLog.append(progLogMsg.toString(sWorkBasketName));
        if (logger.isFinest()) {
            logger.finest("importXMLWorkBasketDefinition --");
        }
    }

    protected static void importXMLWorkBasketDefinitionArray(Node arrayNode, VWQueueDefinition queueDef, VWSession session, int option, StringBuffer progressLog) throws Exception {
        if (arrayNode == null) {
            throw new VWException("vw.api.VWXMLConfiguration.InBasketArrayNullNode", "DOM Node parameter is null");
        }
        if (!arrayNode.getNodeName().equals("ArrayOfInBasketDefinition")) {
            throw new VWException("vw.api.VWXMLConfiguration.InBasketArrayInvalidNode", "Node parameter is not {0}", "ArrayOfInBasketDefinition");
        }
        if (!arrayNode.hasChildNodes()) {
            return;
        }
        NodeList asDefNodeList = ((Element)arrayNode).getElementsByTagName("InBasketDefinition");
        if (asDefNodeList == null) {
            return;
        }
        int childNodeCount = asDefNodeList.getLength();
        for (int i = 0; i < childNodeCount; ++i) {
            VWXMLConfiguration.importXMLWorkBasketDefinition(asDefNodeList.item(i), queueDef, session, option, progressLog);
        }
    }

    protected static void importXMLWorkBasketFilterDefinition(Node aWorkBasketFilterNode, VWWorkBasketDefinition wbDef, VWSession session, int option, StringBuffer progressLog) throws Exception {
        String sPrompt;
        if (aWorkBasketFilterNode == null) {
            throw new VWException("vw.api.VWXMLConfiguration.InBasketFilterDefNullNode", "DOM Node parameter is null");
        }
        Element wrokBasketFilterDefElem = (Element)aWorkBasketFilterNode;
        String sWorkBasketFilterName = wrokBasketFilterDefElem.getAttribute("Name");
        String sDesc = wrokBasketFilterDefElem.getAttribute("Description");
        if (logger.isFinest()) {
            logger.finest("importXMLWorkBasketFilterDefinition enter -- name=" + sWorkBasketFilterName);
        }
        boolean bMerge = false;
        VWWorkBasketFilterDefinition aWorkBasketFilterDef = null;
        if (wbDef.getWorkBasketFilterDefinition(sWorkBasketFilterName) == null) {
            aWorkBasketFilterDef = wbDef.createWorkBasketFilterDefinition(sWorkBasketFilterName);
        } else if ((option & 0xF) == 2) {
            aWorkBasketFilterDef = wbDef.getWorkBasketFilterDefinition(sWorkBasketFilterName);
            bMerge = true;
        } else {
            aWorkBasketFilterDef = wbDef.createWorkBasketFilterDefinition(sWorkBasketFilterName);
        }
        if (!bMerge || aWorkBasketFilterDef.getDescription() == null || aWorkBasketFilterDef.getDescription().trim().length() == 0) {
            aWorkBasketFilterDef.setDescription(sDesc);
        }
        if (!(bMerge && aWorkBasketFilterDef.getPrompt() != null && aWorkBasketFilterDef.getPrompt().trim().length() != 0 || (sPrompt = wrokBasketFilterDefElem.getAttribute("Prompt")) == null)) {
            aWorkBasketFilterDef.setPrompt(sPrompt);
        }
        if (!bMerge || aWorkBasketFilterDef.getSearchField() == null) {
            String searchFieldName;
            int operator = aWorkBasketFilterDef.getOperator();
            String str1 = wrokBasketFilterDefElem.getAttribute("Operator");
            if (str1 != null && str1.length() > 0) {
                operator = Integer.parseInt(str1);
            }
            if ((searchFieldName = wrokBasketFilterDefElem.getAttribute("SearchField")) != null && searchFieldName.trim().length() > 0) {
                VWExposedFieldDefinition searchField = wbDef.m_myQueueDef.getField(searchFieldName);
                if (searchField == null) {
                    if (logger.isFinest()) {
                        logger.finest("importXMLWorkBasketFilterDefinition In-basket filter definition = " + sWorkBasketFilterName + " -- failed to import search field name = " + searchFieldName + ", the exposed field definition for the search field does not exist");
                    }
                    VWString progLogMsg = new VWString("vw.api.VWXMLConfiguration.importXMLWorkBasketFilterDefinition.failedToImportSearchFieldName", "Import In-basket filter definition \"{0}\" - failed to import search field name \"{1}\", the exposed field definition for the search field does not exist\n");
                    progressLog.append(progLogMsg.toString(sWorkBasketFilterName, searchFieldName));
                } else {
                    try {
                        aWorkBasketFilterDef.setSearchField(searchField, operator);
                    }
                    catch (VWException ex) {
                        if (logger.isFinest()) {
                            logger.finest("importXMLWorkBasketFilterDefinition In-basket filter definition = " + sWorkBasketFilterName + " -- failed to import search field (" + searchFieldName + ") and operator ( " + operator + "), the operator can not be applied to the search field type");
                        }
                        VWString progLogMsg = new VWString("vw.api.VWXMLConfiguration.importXMLWorkBasketFilterDefinition.failedToImportSearchFieldAndOperator", "Import In-basket filter definition \"{0}\" - failed to import search field ({1}} and operator ({2}), the operator can not be applied to the search field type\n");
                        progressLog.append(progLogMsg.toString(sWorkBasketFilterName, searchFieldName, Integer.toString(operator)));
                    }
                }
            }
        }
        NodeList childNodes = wrokBasketFilterDefElem.getChildNodes();
        int childNodeCount = childNodes.getLength();
        for (int i = 0; i < childNodeCount; ++i) {
            Node aChildNode = childNodes.item(i);
            String nodeName = aChildNode.getNodeName();
            if (!nodeName.equals("ModelAttributes")) continue;
            Hashtable attributes = VWXMLConfiguration.parseXMLModelAttributes(aChildNode, apiVersion);
            if (bMerge) {
                VWAttributeInfo theAttributeInfo = VWXMLConfiguration.mergeAttributes(session, aWorkBasketFilterDef.getAttributeInfo(), attributes);
                aWorkBasketFilterDef.setAttributeInfo(theAttributeInfo);
                continue;
            }
            aWorkBasketFilterDef.setAttributes(attributes);
        }
        aWorkBasketFilterDef.setHasChanged(true);
        if (logger.isFinest()) {
            logger.finest("importXMLWorkBasketFilterDefinition --");
        }
    }

    protected static void importXMLWorkBasketFilterDefinitionArray(Node arrayNode, VWWorkBasketDefinition wbDef, VWSession session, int option, StringBuffer progressLog) throws Exception {
        if (arrayNode == null) {
            throw new VWException("vw.api.VWXMLConfiguration.InBasketFilterArrayNullNode", "DOM Node parameter is null");
        }
        if (!arrayNode.getNodeName().equals("ArrayOfInBasketFilterDefinition")) {
            throw new VWException("vw.api.VWXMLConfiguration.InBasketFilterArrayInvalidNode", "Node parameter is not {0}", "ArrayOfInBasketFilterDefinition");
        }
        if (!arrayNode.hasChildNodes()) {
            return;
        }
        NodeList asDefNodeList = ((Element)arrayNode).getElementsByTagName("InBasketFilterDefinition");
        if (asDefNodeList == null) {
            return;
        }
        int childNodeCount = asDefNodeList.getLength();
        for (int i = 0; i < childNodeCount; ++i) {
            VWXMLConfiguration.importXMLWorkBasketFilterDefinition(asDefNodeList.item(i), wbDef, session, option, progressLog);
        }
    }

    protected static void importXMLWorkBasketColumnDefinition(Node aWorkBasketColumnNode, VWWorkBasketDefinition wbDef, VWSession session, int option, StringBuffer progressLog) throws Exception {
        if (aWorkBasketColumnNode == null) {
            throw new VWException("vw.api.VWXMLConfiguration.InBaskettColumnDefNullNode", "DOM Node parameter is null");
        }
        Element wrokBasketColumnDefElem = (Element)aWorkBasketColumnNode;
        String sColumnName = wrokBasketColumnDefElem.getAttribute("Column");
        String sPrompt = wrokBasketColumnDefElem.getAttribute("Prompt");
        VWExposedFieldDefinition column = null;
        if (logger.isFinest()) {
            logger.finest("importXMLWorkBasketColumnDefinition enter -- name=" + sColumnName);
        }
        if (sColumnName != null && sColumnName.length() > 0) {
            column = wbDef.m_myQueueDef.getExposedField(sColumnName);
        }
        if (column != null) {
            String str1;
            boolean bMerge = false;
            VWWorkBasketColumnDefinition aWorkBasketColumnDef = null;
            if (wbDef.getWorkBasketColumnDefinition(sColumnName) == null) {
                aWorkBasketColumnDef = wbDef.createWorkBasketColumnDefinition(sPrompt, column);
            } else if ((option & 0xF) == 2) {
                aWorkBasketColumnDef = wbDef.getWorkBasketColumnDefinition(sColumnName);
                if (aWorkBasketColumnDef.m_prompt == null || aWorkBasketColumnDef.m_prompt.length() == 0) {
                    aWorkBasketColumnDef.m_prompt = sPrompt;
                }
                bMerge = true;
            } else {
                aWorkBasketColumnDef = wbDef.createWorkBasketColumnDefinition(sPrompt, column);
            }
            if (!bMerge || aWorkBasketColumnDef.getIndexName() == null || aWorkBasketColumnDef.getIndexName().trim().length() == 0) {
                String sIndexName = wrokBasketColumnDefElem.getAttribute("IndexName");
                if (sIndexName != null) {
                    sIndexName = sIndexName.trim();
                }
                if (sIndexName != null && wbDef.m_myQueueDef != null && wbDef.m_myQueueDef.getIndex(sIndexName) != null) {
                    try {
                        aWorkBasketColumnDef.setIndexName(sIndexName);
                    }
                    catch (VWException ex) {
                        if (logger.isFinest()) {
                            logger.finest("Failed to import index name -- " + ex.getLocalizedMessage());
                        }
                        VWString progLogMsg = new VWString("vw.api.VWXMLConfiguration.importXMLWorkBasketColumnDefinition.failedToImportIndexName", "Failed to import index name \"{0}\" -- " + ex.getLocalizedMessage() + "\n");
                        progressLog.append(progLogMsg.toString(sIndexName));
                    }
                }
            }
            if (!bMerge && (str1 = wrokBasketColumnDefElem.getAttribute("Sortable")) != null && str1.length() > 0) {
                boolean bSortable = Boolean.parseBoolean(str1);
                aWorkBasketColumnDef.setSortable(bSortable);
            }
            NodeList childNodes = wrokBasketColumnDefElem.getChildNodes();
            int childNodeCount = childNodes.getLength();
            for (int i = 0; i < childNodeCount; ++i) {
                Node aChildNode = childNodes.item(i);
                String nodeName = aChildNode.getNodeName();
                if (!nodeName.equals("ModelAttributes")) continue;
                Hashtable attributes = VWXMLConfiguration.parseXMLModelAttributes(aChildNode, apiVersion);
                if (bMerge) {
                    VWAttributeInfo theAttributeInfo = VWXMLConfiguration.mergeAttributes(session, aWorkBasketColumnDef.getAttributeInfo(), attributes);
                    aWorkBasketColumnDef.setAttributeInfo(theAttributeInfo);
                    continue;
                }
                aWorkBasketColumnDef.setAttributes(attributes);
            }
            aWorkBasketColumnDef.setHasChanged(true);
        } else {
            if (logger.isFinest()) {
                logger.finest("importXMLWorkBasketColumnDefinition In-basket column definition = " + sColumnName + " -- failed to import In-basket column definition.  The exposed field for the column definition does not exist");
            }
            VWString progLogMsg = new VWString("vw.api.VWXMLConfiguration.importXMLWorkBasketColumnDefinition.failedToImportColumnDefinition", "Failed to import In-basket column definition \"{0}\" - the exposed field for the column definition does not exist\n");
            progressLog.append(progLogMsg.toString(sColumnName));
        }
        if (logger.isFinest()) {
            logger.finest("importXMLWorkBasketColumnDefinition --");
        }
    }

    protected static void importXMLWorkBasketColumnDefinitionArray(Node arrayNode, VWWorkBasketDefinition wbDef, VWSession session, int option, StringBuffer progressLog) throws Exception {
        if (arrayNode == null) {
            throw new VWException("vw.api.VWXMLConfiguration.InBasketColumnArrayNullNode", "DOM Node parameter is null");
        }
        if (!arrayNode.getNodeName().equals("ArrayOfInBasketColumnDefinition")) {
            throw new VWException("vw.api.VWXMLConfiguration.InBasketColumnArrayInvalidNode", "Node parameter is not {0}", "ArrayOfInBasketColumnDefinition");
        }
        if (!arrayNode.hasChildNodes()) {
            return;
        }
        NodeList asDefNodeList = ((Element)arrayNode).getElementsByTagName("InBasketColumnDefinition");
        if (asDefNodeList == null) {
            return;
        }
        int childNodeCount = asDefNodeList.getLength();
        for (int i = 0; i < childNodeCount; ++i) {
            VWXMLConfiguration.importXMLWorkBasketColumnDefinition(asDefNodeList.item(i), wbDef, session, option, progressLog);
        }
    }

    protected static void importXMLServerIdConfig(Node serverIdConfigNode, VWSystemConfiguration sysConfig, int option) throws VWException {
        int iServerId;
        if (serverIdConfigNode == null) {
            throw new VWException("vw.api.VWXMLConfigurationNullNode", "DOM Node parameter is null");
        }
        Element serverIdConfigElem = (Element)serverIdConfigNode;
        String str1 = serverIdConfigElem.getAttribute("ServerId");
        if (str1 != null && str1.length() > 0 && (iServerId = Integer.parseInt(serverIdConfigElem.getAttribute("ServerId"))) >= 0) {
            VWRosterDefinition aRosterDef;
            String sName = serverIdConfigElem.getAttribute("Name");
            String sType = serverIdConfigElem.getAttribute("Type");
            if (sType.equals("queue")) {
                VWQueueDefinition aQueueDef = sysConfig.getQueueDefinition(sName);
                if (aQueueDef != null) {
                    aQueueDef.setServerId(iServerId);
                }
            } else if (sType.equals("roster") && (aRosterDef = sysConfig.getRosterDefinition(sName)) != null) {
                aRosterDef.setServerId(iServerId);
            }
        }
    }

    protected static void importXMLServerIdConfigArray(Node arrayServerIdConfNode, VWSystemConfiguration sysConfig, int option) throws Exception {
        if (arrayServerIdConfNode == null) {
            throw new VWException("vw.api.VWXMLConfigurationNullNode", "DOM Node parameter is null");
        }
        if (!arrayServerIdConfNode.getNodeName().equals("ArrayOfServerIdConfig")) {
            throw new VWException("vw.api.VWXMLConfigurationInvalidNode", "Node parameter is not {0}", "ArrayOfServerIdConfig");
        }
        if (!arrayServerIdConfNode.hasChildNodes()) {
            return;
        }
        NodeList serverIdConfigNodeList = ((Element)arrayServerIdConfNode).getElementsByTagName("ServerIdConfig");
        if (serverIdConfigNodeList == null) {
            return;
        }
        int childNodeCount = serverIdConfigNodeList.getLength();
        for (int i = 0; i < childNodeCount; ++i) {
            VWXMLConfiguration.importXMLServerIdConfig(serverIdConfigNodeList.item(i), sysConfig, option);
        }
    }

    protected static void importXMLStepProcessorInfoDefinition(Node aSPInfoNode, VWSystemConfiguration sysConfig, int option, StringBuffer progressLog) throws VWException, SAXException, NumberFormatException {
        String str8;
        String str7;
        String str6;
        String str5;
        int i;
        if (aSPInfoNode == null) {
            throw new VWException("vw.api.VWXMLConfigurationNullNode", "DOM Node parameter is null");
        }
        Element SPInfoDefElem = (Element)aSPInfoNode;
        String sSPInfoName = SPInfoDefElem.getAttribute("Name");
        if (logger.isFinest()) {
            logger.finest("importXMLStepProcessorInfoDefinition enter -- name=" + sSPInfoName + " option=" + option);
        }
        Hashtable theLocations = null;
        NodeList childNodes = SPInfoDefElem.getChildNodes();
        int childNodeCount = childNodes.getLength();
        for (int i2 = 0; i2 < childNodeCount; ++i2) {
            Node aChildNode = childNodes.item(i2);
            String nodeName = aChildNode.getNodeName();
            if (!nodeName.equals("ArrayOfLocation")) continue;
            theLocations = VWXMLConfiguration.parseXMLHashtable(aChildNode, 1, "Location");
        }
        VWStepProcessorInfoDefinition[] spiDefs = sysConfig.getStepProcessorInfoDefinitions();
        boolean found = false;
        int foundIndex = -1;
        boolean bImportMerge = (option & 0xF) == 2;
        for (int i3 = 0; spiDefs != null && i3 < spiDefs.length; ++i3) {
            if (!spiDefs[i3].getName().equals(sSPInfoName)) continue;
            found = true;
            foundIndex = i3;
            break;
        }
        if (found && bImportMerge) {
            return;
        }
        VWStepProcessorInfoDefinition aSPInfoDef = null;
        String str1 = SPInfoDefElem.getAttribute("Id");
        int iSPInfoId = -1;
        if (str1 != null && str1.length() > 0) {
            iSPInfoId = Integer.parseInt(str1);
        }
        String str2 = SPInfoDefElem.getAttribute("Type");
        int iSPInfoType = -1;
        if (str2 != null && str2.length() > 0) {
            iSPInfoType = Integer.parseInt(str2);
        }
        if (found && !bImportMerge) {
            int targetType = spiDefs[foundIndex].getProcessorType();
            boolean bMisMatchedType = false;
            if (!(targetType != 1 && targetType != 4 || iSPInfoType != 2 && iSPInfoType != 8)) {
                bMisMatchedType = true;
            }
            if (!(targetType != 2 && targetType != 8 || iSPInfoType != 1 && iSPInfoType != 4)) {
                bMisMatchedType = true;
            }
            if (bMisMatchedType) {
                throw new VWException("vw.api.VWXMLConfigurationImportSPDefConflicatedType", "Conflicting step processor info definition type for {0}", sSPInfoName);
            }
        }
        if (found) {
            aSPInfoDef = spiDefs[foundIndex];
        } else {
            aSPInfoDef = sysConfig.createStepProcessorInfoDefinition();
            aSPInfoDef.setName(sSPInfoName);
            if (iSPInfoId > 0) {
                boolean bFoundId = false;
                for (i = 0; spiDefs != null && i < spiDefs.length; ++i) {
                    if (spiDefs[i].getId() != iSPInfoId) continue;
                    bFoundId = true;
                    break;
                }
                if (!bFoundId) {
                    aSPInfoDef.setId(iSPInfoId);
                }
            }
        }
        if (iSPInfoType > 0) {
            if (bImportMerge) {
                if (!found) {
                    if ((iSPInfoType & 1) == 1) {
                        iSPInfoType &= 0xFFFFFFFE;
                        iSPInfoType |= 4;
                    } else if ((iSPInfoType & 2) == 2) {
                        iSPInfoType &= 0xFFFFFFFD;
                        iSPInfoType |= 8;
                    }
                    aSPInfoDef.setProcessorType(iSPInfoType);
                }
            } else {
                boolean bReplaceDefaultType = false;
                if ((iSPInfoType & 1) == 1) {
                    bReplaceDefaultType = true;
                    for (i = 0; spiDefs != null && i < spiDefs.length; ++i) {
                        if (spiDefs[i].getProcessorType() != 1) continue;
                        spiDefs[i].setProcessorType(4);
                        break;
                    }
                } else if ((iSPInfoType & 2) == 2) {
                    bReplaceDefaultType = true;
                    for (i = 0; spiDefs != null && i < spiDefs.length; ++i) {
                        if (spiDefs[i].getProcessorType() != 2) continue;
                        spiDefs[i].setProcessorType(8);
                        break;
                    }
                }
                if (!found || bReplaceDefaultType) {
                    aSPInfoDef.setProcessorType(iSPInfoType);
                }
            }
        }
        String sAppName = SPInfoDefElem.getAttribute("ApplicationName");
        aSPInfoDef.setApplicationName(sAppName);
        String str3 = SPInfoDefElem.getAttribute("AppType");
        if (str3 != null && str3.length() > 0) {
            int iAppType = Integer.parseInt(str3);
            aSPInfoDef.setAppType(iAppType);
        }
        if ((str5 = SPInfoDefElem.getAttribute("Width")) != null && str5.length() > 0) {
            int iWidth = Integer.parseInt(str5);
            aSPInfoDef.setWidth(iWidth);
        }
        if ((str6 = SPInfoDefElem.getAttribute("Height")) != null && str6.length() > 0) {
            int iHeight = Integer.parseInt(str6);
            aSPInfoDef.setHeight(iHeight);
        }
        if ((str7 = SPInfoDefElem.getAttribute("DefaultWebAppId")) != null && str7.length() > 0) {
            int iDefaultWebId = Integer.parseInt(str7);
            aSPInfoDef.setDefaultWebAppId(iDefaultWebId);
        }
        if ((str8 = SPInfoDefElem.getAttribute("IsolatedRegionWebAppId")) != null && str8.length() > 0) {
            int iIsolatedRegionWebAppId = Integer.parseInt(str8);
            aSPInfoDef.setIsolatedRegionWebAppId(iIsolatedRegionWebAppId);
        }
        aSPInfoDef.setLocations(theLocations);
        aSPInfoDef.setHasChanged(true);
        VWString progLogMsg = new VWString("vw.api.VWXMLConfiguration.importXMLStepProcessorInfoDefinition", "Import step processor info \"{0}\", type: {1} succeeded\n");
        progressLog.append(progLogMsg.toString(sSPInfoName, str2));
        if (logger.isFinest()) {
            logger.finest("importXMLStepProcessorInfoDefinition -- name=" + sSPInfoName + " type=" + str2 + ", applicationName=" + sAppName);
        }
    }

    protected static void importXMLStepProcessorInfoDefinitionArray(Node arraySPInfoNode, VWSystemConfiguration sysConfig, int option, StringBuffer progressLog) throws VWException, SAXException, NumberFormatException {
        if (arraySPInfoNode == null) {
            throw new VWException("vw.api.VWXMLConfigurationNullNode", "DOM Node parameter is null");
        }
        if (!arraySPInfoNode.getNodeName().equals("ArrayOfStepProcessorInfoDefinition")) {
            throw new VWException("vw.api.VWXMLConfigurationInvalidNode", "Node parameter is not {0}", "ArrayOfStepProcessorInfoDefinition");
        }
        if (!arraySPInfoNode.hasChildNodes()) {
            return;
        }
        NodeList SPInfoDefNodeList = ((Element)arraySPInfoNode).getElementsByTagName("StepProcessorInfoDefinition");
        if (SPInfoDefNodeList == null) {
            return;
        }
        int childNodeCount = SPInfoDefNodeList.getLength();
        for (int i = 0; i < childNodeCount; ++i) {
            VWXMLConfiguration.importXMLStepProcessorInfoDefinition(SPInfoDefNodeList.item(i), sysConfig, option, progressLog);
        }
    }

    protected static Element parseXMLConfiguration(InputSource inputSrc) throws IOException, SAXException, VWException, NumberFormatException {
        Document doc = XMLHelper.parseDocumentViaDOM(inputSrc, new VWResolver(), new VWXMLErrorHandler(), false);
        Element configEle = doc.getDocumentElement();
        return configEle;
    }

    protected static Element parseXMLConfiguration(BufferedReader inputXML) throws IOException, SAXException, VWException, NumberFormatException {
        return VWXMLConfiguration.parseXMLConfiguration(new InputSource(inputXML));
    }

    protected static VWDBExecuteConnection parseXMLDBExecuteConnection(Node aDBExeNode) throws VWException, SAXException {
        if (aDBExeNode == null) {
            throw new VWException("vw.api.VWXMLConfigurationNullNode", "DOM Node DBExecuteConnection is null");
        }
        Element dbExeElem = (Element)aDBExeNode;
        String sName = dbExeElem.getAttribute("Name");
        int dbType = Integer.parseInt(dbExeElem.getAttribute("Type"));
        String sURL = dbExeElem.getAttribute("URL");
        String sDBName = dbExeElem.getAttribute("DBName");
        String sDBHost = dbExeElem.getAttribute("DBHost");
        int dbPort = 0;
        String sDBPort = dbExeElem.getAttribute("Port");
        if (sDBPort != null && sDBPort.length() > 0) {
            dbPort = Integer.parseInt(sDBPort);
        }
        String sUserName = dbExeElem.getAttribute("UserName");
        String sPWD = dbExeElem.getAttribute("Password");
        VWDBExecuteConnection aDBExecute = new VWDBExecuteConnection();
        aDBExecute.setName(sName);
        aDBExecute.setDbType(dbType);
        aDBExecute.setURL(sURL);
        aDBExecute.setDbName(sDBName);
        aDBExecute.setDbHostName(sDBHost);
        aDBExecute.setDbPort(dbPort);
        aDBExecute.setDbUserId(sUserName);
        if (sPWD != null && sPWD.length() > 0) {
            aDBExecute.setPWD(sPWD);
        }
        return aDBExecute;
    }

    protected static VWDBExecuteConnection[] parseXMLDBExecuteConnectionArray(Node arrayDBExecuteNode) throws VWException, SAXException {
        if (arrayDBExecuteNode == null) {
            throw new VWException("vw.api.VWXMLConfigurationNullNode", "DOM Node ArrayOfDBExecuteConnections is null");
        }
        if (!arrayDBExecuteNode.getNodeName().equals("ArrayOfDBExecuteConnection")) {
            throw new VWException("vw.api.VWXMLConfigurationInvalidNode", "Node is not {0}", "ArrayOfDBExecuteConnection");
        }
        if (!arrayDBExecuteNode.hasChildNodes()) {
            return null;
        }
        NodeList dbExecuteNodeList = ((Element)arrayDBExecuteNode).getElementsByTagName("VWDBExecuteConnection");
        if (dbExecuteNodeList == null) {
            return null;
        }
        int childNodeCount = dbExecuteNodeList.getLength();
        VWDBExecuteConnection[] dbExeList = new VWDBExecuteConnection[childNodeCount];
        for (int i = 0; i < childNodeCount; ++i) {
            dbExeList[i] = VWXMLConfiguration.parseXMLDBExecuteConnection(dbExecuteNodeList.item(i));
        }
        return dbExeList;
    }

    protected static VWExposedFieldDefinition parseXMLExposedFieldDefinition(Node aEPDefNode) throws VWException {
        VWExposedFieldDefinition aFieldDefinitions = null;
        String efdName = "";
        try {
            Element efdElm = (Element)aEPDefNode;
            if (logger.isFinest()) {
                logger.finest("parseXMLExposedFieldDefinition enter --");
            }
            efdName = efdElm.getAttribute("Name");
            int efdType = VWFieldType.stringToType(efdElm.getAttribute("Type"));
            if (efdType == 256) {
                efdType = 16;
            }
            int efdLength = Integer.parseInt(efdElm.getAttribute("Length"));
            boolean bIsSystemField = VWXMLHandler.stringToBoolean(efdElm.getAttribute("IsSystemField"));
            boolean bIsMandatorySystemField = VWXMLHandler.stringToBoolean(efdElm.getAttribute("IsMandatorySystemField"));
            String sSourceName = efdElm.getAttribute("SourceName");
            int iSourceType = Integer.parseInt(efdElm.getAttribute("SourceType"));
            aFieldDefinitions = new VWExposedFieldDefinition(efdName, efdType, efdLength, bIsSystemField, sSourceName, iSourceType);
            aFieldDefinitions.setMandatorySystemField(bIsMandatorySystemField);
            if (logger.isFinest()) {
                logger.finest("parseXMLExposedFieldDefinition -- name=" + efdName + ", type=" + efdType + ", isSystemField=" + bIsSystemField);
            }
        }
        catch (Exception ex) {
            VWException vwex = new VWException("vw.api.VWXMLConfigurationParseFieldDefinitionWithName", "Invalid field definition XML. Failed to parse field {0}", efdName);
            vwex.setCause(ex);
            throw vwex;
        }
        return aFieldDefinitions;
    }

    protected static VWExposedFieldDefinition[] parseXMLExposedFieldDefinitionArray(Node arrayOfEPDefNode) throws VWException {
        VWExposedFieldDefinition[] arrayOfFieldDefinitions = null;
        NodeList exposeFieldDefList = ((Element)arrayOfEPDefNode).getElementsByTagName("ExposedFieldDefinition");
        if (exposeFieldDefList != null) {
            int listSize = exposeFieldDefList.getLength();
            arrayOfFieldDefinitions = new VWExposedFieldDefinition[listSize];
            for (int j = 0; j < listSize; ++j) {
                arrayOfFieldDefinitions[j] = VWXMLConfiguration.parseXMLExposedFieldDefinition(exposeFieldDefList.item(j));
            }
        }
        return arrayOfFieldDefinitions;
    }

    protected static Hashtable parseXMLHashtable(Node tableNode, int keyType, String elementTag) throws VWException {
        Hashtable<Object, Object> theTable = new Hashtable<Object, Object>();
        try {
            NodeList childNodes = ((Element)tableNode).getElementsByTagName(elementTag);
            int childNodeCount = childNodes.getLength();
            for (int i = 0; i < childNodeCount; ++i) {
                Element aTableElem = (Element)childNodes.item(i);
                String sKeyVal = aTableElem.getAttribute("Name");
                Object oKeyVal = null;
                switch (keyType) {
                    case 1: {
                        oKeyVal = new Integer(sKeyVal);
                        break;
                    }
                    case 8: {
                        oKeyVal = new Double(sKeyVal);
                        break;
                    }
                    case 4: {
                        oKeyVal = Boolean.valueOf(sKeyVal);
                        break;
                    }
                    case 16: {
                        oKeyVal = VWXMLUtil.convertUTCStringToDate(sKeyVal);
                        break;
                    }
                    case 2: {
                        oKeyVal = sKeyVal;
                        break;
                    }
                    case 512: {
                        oKeyVal = new VWGuid(sKeyVal);
                        break;
                    }
                    default: {
                        throw new VWException("vw.api.VWSimpleTypeBadString", "integer form of the field type is invalid: {0}", String.valueOf(keyType));
                    }
                }
                int iType = Integer.parseInt(aTableElem.getAttribute("Type"));
                boolean bIsArray = VWXMLHandler.stringToBoolean(aTableElem.getAttribute("IsArray"));
                NodeList valList = aTableElem.getElementsByTagName("Value");
                int valListSize = valList.getLength();
                Object[] colVal = new Object[valListSize];
                for (int j = 0; j < valListSize; ++j) {
                    Element valElem = (Element)valList.item(j);
                    String valueStr = VWXMLConfiguration.getNodeStringValue(valElem);
                    Object oValue = null;
                    switch (iType) {
                        case 1: {
                            oValue = new Integer(valueStr);
                            break;
                        }
                        case 8: {
                            oValue = new Double(valueStr);
                            break;
                        }
                        case 4: {
                            oValue = Boolean.valueOf(valueStr);
                            break;
                        }
                        case 16: {
                            oValue = VWXMLUtil.convertUTCStringToDate(valueStr);
                            break;
                        }
                        case 2: {
                            oValue = valueStr;
                            break;
                        }
                        case 512: {
                            oKeyVal = new VWGuid(valueStr);
                            break;
                        }
                        default: {
                            throw new VWException("vw.api.VWSimpleTypeBadString", "integer form of the field type is invalid: {0}", String.valueOf(iType));
                        }
                    }
                    colVal[j] = oValue;
                }
                if (bIsArray) {
                    theTable.put(oKeyVal, colVal);
                    continue;
                }
                theTable.put(oKeyVal, colVal[0]);
            }
        }
        catch (VWException ex) {
            throw ex;
        }
        catch (Exception ex) {
            VWException vwex = new VWException("vw.api.VWXMLConfigurationParseHashtable", "Failed to parse {0} hashtable XML", elementTag);
            vwex.setCause(ex);
            throw vwex;
        }
        return theTable;
    }

    protected static VWIndexDefinition[] parseXMLIndexDefinitionArray(Node arrayOfIndexDefNode, VWTableDefinition tblDef) throws VWException {
        Object[] arrayOfIndexDefinitions = null;
        NodeList indexDefList = ((Element)arrayOfIndexDefNode).getElementsByTagName("IndexDefinition");
        if (indexDefList != null) {
            Vector<VWIndexDefinition> colIndexDef = new Vector<VWIndexDefinition>();
            int listSize = indexDefList.getLength();
            for (int j = 0; j < listSize; ++j) {
                Element idxElm = (Element)indexDefList.item(j);
                String idxName = idxElm.getAttribute("Name");
                boolean bIsSystemIndex = VWXMLHandler.stringToBoolean(idxElm.getAttribute("IsSystemIndex"));
                boolean bIsMandatorySystemIndex = VWXMLHandler.stringToBoolean(idxElm.getAttribute("IsMandatorySystemIndex"));
                NodeList fieldNames = idxElm.getElementsByTagName("FieldNames");
                NodeList fieldNameList = ((Element)fieldNames.item(0)).getElementsByTagName("Value");
                int fieldNameListSize = fieldNameList.getLength();
                if (fieldNameListSize <= 0) continue;
                String[] theFieldNames = new String[fieldNameListSize];
                for (int k = 0; k < fieldNameListSize; ++k) {
                    Element valueNode = (Element)fieldNameList.item(k);
                    theFieldNames[k] = VWXMLConfiguration.getNodeStringValue(valueNode);
                }
                VWIndexDefinition aIndexDefinition = new VWIndexDefinition(idxName, theFieldNames, bIsSystemIndex, tblDef);
                aIndexDefinition.setMandatorySystemIndex(bIsMandatorySystemIndex);
                colIndexDef.add(aIndexDefinition);
            }
            int vectorSize = colIndexDef.size();
            if (vectorSize > 0) {
                arrayOfIndexDefinitions = new VWIndexDefinition[vectorSize];
                colIndexDef.copyInto(arrayOfIndexDefinitions);
            }
        }
        return arrayOfIndexDefinitions;
    }

    protected static Hashtable parseXMLModelAttributes(Node aNode, String verStr) throws VWException, SAXException, NumberFormatException {
        if (verStr.equals("4.0")) {
            return VWXML_CUR_parser.parseXMLModelAttributes(aNode);
        }
        throw new VWException("vw.api.VWXMLConfigurationBadAPIVersion", "The XML file contains an ApiVersion attribute, {0}, which cannot be parsed by this version of the PW API.", verStr);
    }

    protected static VWParameterDefinition parseXMLParameterDefinition(Node aParamDefNode) throws VWException, SAXException {
        if (aParamDefNode == null) {
            throw new VWException("vw.api.VWXMLConfigurationNullNode", "DOM Node parameter is null");
        }
        Element paramDefElem = (Element)aParamDefNode;
        String sParamName = paramDefElem.getAttribute("Name");
        String sParamDesc = paramDefElem.getAttribute("Description");
        int iParamType = VWFieldType.stringToType(paramDefElem.getAttribute("Type"));
        int iMode = VWModeType.stringToType(paramDefElem.getAttribute("Mode"));
        boolean isArray = VWXMLHandler.stringToBoolean(paramDefElem.getAttribute("IsArray"));
        VWParameterDefinition aParameterDef = new VWParameterDefinition(sParamName, iMode, iParamType, isArray, sParamDesc);
        return aParameterDef;
    }

    protected static VWParameterDefinition[] parseXMLParameterDefinitionArray(Node arrayParamDefNode) throws VWException, SAXException {
        if (arrayParamDefNode == null) {
            throw new VWException("vw.api.VWXMLConfigurationNullNode", "DOM Node parameter is null");
        }
        if (!arrayParamDefNode.getNodeName().equals("ArrayOfParameterDefinition")) {
            throw new VWException("vw.api.VWXMLConfigurationInvalidNode", "Node parameter is not {0}", "ArrayOfParameterDefinition");
        }
        if (!arrayParamDefNode.hasChildNodes()) {
            return null;
        }
        NodeList paramDefNodeList = ((Element)arrayParamDefNode).getElementsByTagName("Parameter");
        if (paramDefNodeList == null) {
            return null;
        }
        int childNodeCount = paramDefNodeList.getLength();
        VWParameterDefinition[] arrayOfParameterDef = new VWParameterDefinition[childNodeCount];
        for (int i = 0; i < childNodeCount; ++i) {
            arrayOfParameterDef[i] = VWXMLConfiguration.parseXMLParameterDefinition(paramDefNodeList.item(i));
        }
        return arrayOfParameterDef;
    }

    protected static String[] parseXMLSecurityList(Node aSecurityNode, VWSession session, StringBuffer progressLog) throws VWException, SAXException {
        NodeList securityNodeList = ((Element)aSecurityNode).getElementsByTagName("Value");
        int listSize = securityNodeList.getLength();
        Object[] securityList = null;
        Vector<String> securityCol = new Vector<String>();
        for (int i = 0; i < listSize; ++i) {
            Node valueNode = securityNodeList.item(i);
            String userName = VWXMLConfiguration.getNodeStringValue(valueNode);
            VWUserInfo userInfo = null;
            try {
                if (session != null) {
                    userInfo = session.fetchUserInfo(userName);
                }
            }
            catch (Throwable t) {
                VWString progLogMsg = new VWString("vw.api.VWXMLConfiguration.parseXMLSecurityListSkipUser", "    Import security: skip user \"{0}\" due to the following reason\n");
                progressLog.append(progLogMsg.toString(userName));
                progressLog.append("    " + t.getLocalizedMessage() + "\n");
            }
            if (userInfo == null && session != null) continue;
            securityCol.add(userName);
        }
        if (securityCol != null && securityCol.size() > 0) {
            securityList = new String[securityCol.size()];
            securityCol.copyInto(securityList);
        }
        return securityList;
    }

    protected static VWStepProcessorInfoDefinition parseXMLStepProcessorInfoDefinition(Node aSPInfoNode) throws VWException, SAXException, NumberFormatException {
        if (aSPInfoNode == null) {
            throw new VWException("vw.api.VWXMLConfigurationNullNode", "DOM Node parameter is null");
        }
        Element SPInfoDefElem = (Element)aSPInfoNode;
        String sSPInfoName = SPInfoDefElem.getAttribute("Name");
        int iSPInfoId = Integer.parseInt(SPInfoDefElem.getAttribute("Id"));
        int iSPInfoType = Integer.parseInt(SPInfoDefElem.getAttribute("Type"));
        String sAppName = SPInfoDefElem.getAttribute("ApplicationName");
        int iAppType = Integer.parseInt(SPInfoDefElem.getAttribute("AppType"));
        int iWidth = Integer.parseInt(SPInfoDefElem.getAttribute("Width"));
        int iHeight = Integer.parseInt(SPInfoDefElem.getAttribute("Height"));
        Hashtable theLocations = null;
        NodeList childNodes = SPInfoDefElem.getChildNodes();
        int childNodeCount = childNodes.getLength();
        for (int i = 0; i < childNodeCount; ++i) {
            Node aChildNode = childNodes.item(i);
            String nodeName = aChildNode.getNodeName();
            if (!nodeName.equals("ArrayOfLocation")) continue;
            theLocations = VWXMLConfiguration.parseXMLHashtable(aChildNode, 1, "Location");
        }
        VWStepProcessorInfoDefinition aSPInfoDef = new VWStepProcessorInfoDefinition(iSPInfoId, iSPInfoType, sSPInfoName, iAppType, theLocations, iWidth, iHeight, sAppName);
        return aSPInfoDef;
    }

    protected static VWStepProcessorInfoDefinition[] parseXMLStepProcessorInfoDefinitionsArray(Node arraySPInfoNode) throws VWException, SAXException, NumberFormatException {
        if (arraySPInfoNode == null) {
            throw new VWException("vw.api.VWXMLConfigurationNullNode", "DOM Node parameter is null");
        }
        if (!arraySPInfoNode.getNodeName().equals("ArrayOfStepProcessorInfoDefinition")) {
            throw new VWException("vw.api.VWXMLConfigurationInvalidNode", "Node parameter is not {0}", "ArrayOfStepProcessorInfoDefinition");
        }
        if (!arraySPInfoNode.hasChildNodes()) {
            return null;
        }
        NodeList SPInfoDefNodeList = ((Element)arraySPInfoNode).getElementsByTagName("StepProcessorInfoDefinition");
        if (SPInfoDefNodeList == null) {
            return null;
        }
        int childNodeCount = SPInfoDefNodeList.getLength();
        VWStepProcessorInfoDefinition[] arrayOfSPInfoDef = new VWStepProcessorInfoDefinition[childNodeCount];
        for (int i = 0; i < childNodeCount; ++i) {
            arrayOfSPInfoDef[i] = VWXMLConfiguration.parseXMLStepProcessorInfoDefinition(SPInfoDefNodeList.item(i));
        }
        return arrayOfSPInfoDef;
    }

    protected static VWUserInfo parseXMLUserInfoRecord(Node aNode, VWSystemAdministration sysAdmin, int option, StringBuffer progressLog) throws VWException, SAXException {
        VWString progLogMsg;
        if (aNode == null) {
            throw new VWException("vw.api.VWXMLConfigurationNullNode", "DOM Node parameter is null");
        }
        Element anElement = (Element)aNode;
        String userName = anElement.getAttribute("UserName");
        VWUserInfo userInfo = null;
        boolean bUserExist = false;
        try {
            userInfo = sysAdmin.fetchUserInfo(userName);
            if (userInfo == null) {
                throw new VWException("vw.api.VWXMLConfigurationNullUserInfo", "Unable to fetch/create UserInfo record for user \"{0}\".", userName);
            }
            bUserExist = true;
        }
        catch (VWException ex) {
            progLogMsg = new VWString("vw.api.VWXMLConfiguration.parseXMLUserInfoRecordSkipUser", "    Import user Information: skip user \"{0}\" due to the following reason\n");
            progressLog.append(progLogMsg.toString(userName));
            progressLog.append("    " + ex.getLocalizedMessage() + "\n");
        }
        if (bUserExist) {
            String currentProxyUserName;
            String notificationFlagsStr;
            String prefLocStr;
            boolean bImportReplace = (option & 0xF) == 1;
            String emailAddress = anElement.getAttribute("EmailAddress");
            if (bImportReplace || userInfo.getEMailAddress() == null || userInfo.getEMailAddress().length() <= 0) {
                userInfo.setEMailAddress(emailAddress);
            }
            if ((prefLocStr = anElement.getAttribute("PreferredLocale")) != null && prefLocStr != "" && (bImportReplace || userInfo.getPreferredLocale() == null)) {
                userInfo.setPreferredLocale(VWLocale.parseLocale(prefLocStr));
            }
            if ((notificationFlagsStr = anElement.getAttribute("NotificationFlags")) != null && notificationFlagsStr.length() > 0) {
                int notificationFlags = Integer.parseInt(notificationFlagsStr);
                if (bImportReplace || notificationFlags > 0 && userInfo.getNotificationFlags() == 0) {
                    userInfo.setNotificationFlags(notificationFlags);
                }
            }
            String proxyUserDomain = anElement.getAttribute("ProxyUserDomain");
            String proxyUserName = anElement.getAttribute("ProxyUserName");
            if (proxyUserName != null && proxyUserName.length() > 0) {
                try {
                    currentProxyUserName = userInfo.getProxyUserName();
                    if (bImportReplace) {
                        if (currentProxyUserName == null || currentProxyUserName.length() == 0 || currentProxyUserName.compareTo(proxyUserName) != 0) {
                            userInfo.setProxyUserNameByDomain(proxyUserDomain, proxyUserName);
                        }
                    } else if (currentProxyUserName == null || currentProxyUserName.length() == 0) {
                        userInfo.setProxyUserNameByDomain(proxyUserDomain, proxyUserName);
                    }
                }
                catch (Exception ex) {
                    userInfo.setProxyUserName(null);
                    progLogMsg = new VWString("vw.api.VWXMLConfiguration.parseXMLUserInfoRecordSkipProxyUser", "    Import user Information \"{0}\": skip proxy user \"{1}\" due to the following reason\n");
                    progressLog.append(progLogMsg.toString(userName, proxyUserName));
                    progressLog.append("    " + ex.getLocalizedMessage() + "\n");
                }
            } else if (anElement.hasAttribute("ProxyUserName") && bImportReplace && (currentProxyUserName = userInfo.getProxyUserName()) != null && currentProxyUserName.length() > 0) {
                userInfo.setProxyUserNameByDomain(proxyUserDomain, null);
            }
            Hashtable fields = null;
            NodeList childNodes = anElement.getChildNodes();
            int childNodeCount = childNodes.getLength();
            for (int i = 0; i < childNodeCount; ++i) {
                Node aChildNode = childNodes.item(i);
                String nodeName = aChildNode.getNodeName();
                if (!nodeName.equals("Fields")) continue;
                fields = VWXMLConfiguration.parseXMLHashtable(aChildNode, 2, "Field");
                Enumeration enum1 = fields.keys();
                while (enum1.hasMoreElements()) {
                    String key = (String)enum1.nextElement();
                    if (!bImportReplace && userInfo.fieldsHash != null && userInfo.fieldsHash.containsKey(key)) continue;
                    userInfo.setFieldValue(key, fields.get(key));
                }
            }
        }
        return userInfo;
    }

    protected static VWUserInfo[] parseXMLUserInfoRecords(Node arrayNode, VWSystemAdministration sysAdmin, int option, StringBuffer progressLog) throws VWException, SAXException {
        if (arrayNode == null) {
            throw new VWException("vw.api.VWXMLConfigurationNullNode", "DOM Node parameter is null");
        }
        if (!arrayNode.getNodeName().equals("ArrayOfUserInfo")) {
            throw new VWException("vw.api.VWXMLConfigurationInvalidNode", "Node parameter is not {0}", "ArrayOfUserInfo");
        }
        if (!arrayNode.hasChildNodes()) {
            return null;
        }
        NodeList nodeList = ((Element)arrayNode).getElementsByTagName("UserInfo");
        if (nodeList == null) {
            return null;
        }
        int nodeCount = nodeList.getLength();
        Vector<VWUserInfo> userInfoList = new Vector<VWUserInfo>();
        for (int i = 0; i < nodeCount; ++i) {
            VWUserInfo aUserInfo = VWXMLConfiguration.parseXMLUserInfoRecord(nodeList.item(i), sysAdmin, option, progressLog);
            if (aUserInfo == null) continue;
            userInfoList.add(aUserInfo);
        }
        int listSz = userInfoList.size();
        Object[] arrayOfUserInfo = new VWUserInfo[listSz];
        userInfoList.copyInto(arrayOfUserInfo);
        return arrayOfUserInfo;
    }

    protected static String getNodeStringValue(Node aNode) {
        if (aNode != null) {
            NodeList childNodes = aNode.getChildNodes();
            if (childNodes == null) {
                return null;
            }
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Node childNode = childNodes.item(i);
                if (childNode.getNodeType() != 3) continue;
                return childNode.getNodeValue();
            }
        }
        return null;
    }

    protected static String[] mergeArrays(Object[] array1, Object[] array2) {
        int i;
        Vector<Object> result = new Vector<Object>();
        for (i = 0; array1 != null && i < array1.length; ++i) {
            result.add(array1[i]);
        }
        for (i = 0; array2 != null && i < array2.length; ++i) {
            boolean found = false;
            for (int j = 0; array1 != null && j < array1.length; ++j) {
                if (!array2[i].equals(array1[j])) continue;
                found = true;
                break;
            }
            if (found) continue;
            result.add(array2[i]);
        }
        if (result.size() > 0) {
            return result.toArray(new String[0]);
        }
        return null;
    }

    protected static VWAttributeInfo mergeAttributes(VWSession session, VWAttributeInfo ainfo, Hashtable attributes) throws Exception {
        Enumeration keys = attributes.keys();
        while (keys != null && keys.hasMoreElements()) {
            Object importedRegistryList;
            String importedValue;
            String currentValue;
            String key = (String)keys.nextElement();
            boolean found = false;
            String[] anames = ainfo.getAttributeNames();
            if (anames != null) {
                for (int k = 0; k < anames.length; ++k) {
                    if (!anames[k].equals(key)) continue;
                    found = true;
                    break;
                }
            }
            if (key.compareTo("F_UDDIRegistries") == 0) {
                VWUDDIRegistryList currentRegistryList = null;
                if (!found) {
                    currentRegistryList = new VWUDDIRegistryList(session);
                    currentRegistryList.setDefaultRegionBusinessEntity();
                } else {
                    currentValue = (String)ainfo.getFieldValue(key);
                    currentRegistryList = new VWUDDIRegistryList(ainfo, currentValue, session);
                }
                importedValue = (String)attributes.get(key);
                importedRegistryList = new VWUDDIRegistryList(ainfo, importedValue, null);
                currentRegistryList.mergeRegistrList((VWUDDIRegistryList)importedRegistryList);
                ainfo.setFieldValue(key, currentRegistryList.toXML());
                continue;
            }
            if (key.compareTo("F_WSRRRegistries") == 0) {
                VWWSRRRegistryList currentRegistryList = null;
                if (!found) {
                    currentRegistryList = new VWWSRRRegistryList(session);
                } else {
                    currentValue = (String)ainfo.getFieldValue(key);
                    currentRegistryList = new VWWSRRRegistryList(ainfo, currentValue, session);
                }
                importedValue = (String)attributes.get(key);
                importedRegistryList = new VWWSRRRegistryList(ainfo, importedValue, null);
                currentRegistryList.mergeRegistryList((VWWSRRRegistryList)importedRegistryList);
                ainfo.setFieldValue(key, currentRegistryList.toXML());
                continue;
            }
            if (key.compareTo(ATTRINFO_CONFIG_ALLOW_USER_ENTER_WSDL) == 0) {
                if (found) continue;
                ainfo.setFieldValue(key, "0");
                continue;
            }
            if (found) {
                if (!key.startsWith("CB_") && !key.startsWith("ECM_")) continue;
                ainfo.setFieldValue(key, attributes.get(key));
                continue;
            }
            ainfo.setFieldValue(key, attributes.get(key));
        }
        return ainfo;
    }

    protected static Hashtable reviseXMLModelAttributes(VWSession session, Hashtable attributes) throws Exception {
        Enumeration keys = attributes.keys();
        boolean bEnabledWSDL = false;
        boolean bFound = false;
        while (keys != null && keys.hasMoreElements()) {
            String importedValue;
            VWUDDIRegistryList importedRegistryList;
            String key = (String)keys.nextElement();
            if (key.compareTo(ATTRINFO_CONFIG_ALLOW_USER_ENTER_WSDL) == 0) {
                bFound = true;
            }
            if (key.compareTo("F_UDDIRegistries") != 0 || (importedRegistryList = new VWUDDIRegistryList(null, importedValue = (String)attributes.get(key), null)) == null) continue;
            bEnabledWSDL = importedRegistryList.getAllowUserEnterWSDL();
            BusinessEntity oBusinessEntity = importedRegistryList.getRegionBusinessEntity();
            if (oBusinessEntity == null) continue;
            VWUDDIRegistryList currentRegistryList = new VWUDDIRegistryList(session);
            currentRegistryList.setDefaultRegionBusinessEntity();
            BusinessEntity currentRegionBusiness = currentRegistryList.getRegionBusinessEntity();
            oBusinessEntity.setBusinessKey(currentRegionBusiness.getBusinessKey());
            String xmlValue = importedRegistryList.toXML();
            attributes.put(key, xmlValue);
        }
        if (!bFound) {
            attributes.put(ATTRINFO_CONFIG_ALLOW_USER_ENTER_WSDL, bEnabledWSDL ? "1" : "0");
        }
        return attributes;
    }

    protected static boolean validateConfigurationXML(Document doc, Element documentElement) {
        if (documentElement == null) {
            documentElement = doc.getDocumentElement();
        }
        return documentElement.getNodeName().equals("eProcessConfiguration");
    }

    private static boolean checkOption(int option) {
        int baseOption = option & 0xF;
        return baseOption == 1 || baseOption == 2;
    }

    private static int mergeSystemWideFlags(int sourceFlag, int targetFlag) {
        int result = targetFlag;
        if ((sourceFlag & 1) == 1) {
            result |= 1;
        }
        if ((sourceFlag & 2) == 2) {
            result |= 2;
        }
        if ((sourceFlag & 4) == 4) {
            result |= 4;
        }
        if ((sourceFlag & 0x200) == 512) {
            result |= 0x200;
        }
        if ((sourceFlag & 0x400) == 1024) {
            result |= 0x400;
        }
        if ((sourceFlag & 0x800) == 2048) {
            result |= 0x800;
        }
        if ((targetFlag & 0x10) == 16 && (sourceFlag & 0x10) == 0) {
            result ^= 0x10;
        }
        if ((targetFlag & 0x40) == 64 && (sourceFlag & 0x40) == 0) {
            result ^= 0x40;
        }
        if ((targetFlag & 0x20) == 32 && (sourceFlag & 0x20) == 0) {
            result ^= 0x20;
        }
        if ((targetFlag & 0x100) == 256 && (sourceFlag & 0x100) == 0) {
            result ^= 0x100;
        }
        return result;
    }

    static {
        logger = Logger.getLogger("filenet.vw.api");
        vstrImportOverwrite = new VWString("vw.api.VWXMLConfiguration.ImportOverwrite", "Overwrite");
        vstrImportMerge = new VWString("vw.api.VWXMLConfiguration.ImportMerge", "Merge");
    }
}

